/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.optimization;

import com.yahoo.document.predicate.FeatureRange;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.predicate.PredicateOperator;
import com.yahoo.document.predicate.RangeEdgePartition;
import com.yahoo.document.predicate.RangePartition;
import com.yahoo.search.predicate.optimization.PredicateOptions;
import com.yahoo.search.predicate.optimization.PredicateProcessor;

public class ComplexNodeTransformer
implements PredicateProcessor {
    public void processPredicate(Predicate predicate, PredicateOptions options) {
        if (predicate instanceof PredicateOperator) {
            for (Predicate p : ((PredicateOperator)predicate).getOperands()) {
                this.processPredicate(p, options);
            }
        } else if (predicate instanceof FeatureRange) {
            this.processFeatureRange((FeatureRange)predicate, options);
        }
    }

    private void processFeatureRange(FeatureRange range, PredicateOptions options) {
        range.clearPartitions();
        int arity = options.getArity();
        RangePruner rangePruner = new RangePruner(range, options, arity);
        long from = rangePruner.getFrom();
        long to = rangePruner.getTo();
        if (from < 0L) {
            if (to < 0L) {
                this.partitionRange(range, to == -1L ? 0L : -to, -from, arity, true);
            } else {
                this.partitionRange(range, 0L, -from, arity, true);
                this.partitionRange(range, 0L, to, arity, false);
            }
        } else {
            this.partitionRange(range, from, to, arity, false);
        }
    }

    private void partitionRange(FeatureRange range, long from, long to, int arity, boolean isNeg) {
        int fromRemainder = Math.abs((int)(from % (long)arity));
        int toRemainder = ((int)((to - (long)arity + 1L) % (long)arity) + arity) % arity;
        long fromVal = from - (long)fromRemainder;
        long toVal = to - (long)toRemainder;
        long fromValDividedByArity = Math.abs(fromVal / (long)arity);
        if (fromVal - 1L == toVal) {
            this.addEdgePartition(range, fromVal, fromRemainder, toRemainder - 1, isNeg);
            return;
        }
        if (fromRemainder != 0) {
            this.addEdgePartition(range, fromVal, fromRemainder, -1, isNeg);
            ++fromValDividedByArity;
        }
        if (toRemainder != 0) {
            this.addEdgePartition(range, toVal + 1L, -1, toRemainder - 1, isNeg);
        }
        this.makePartitions(range, fromValDividedByArity, Math.abs((toVal - (long)(arity - 1)) / (long)arity) + 1L, arity, arity, isNeg);
    }

    private void addEdgePartition(FeatureRange range, long value, int from, int to, boolean isNeg) {
        String label = value == Long.MIN_VALUE ? range.getKey() + "=-9223372036854775808" : range.getKey() + (isNeg ? "=-" : "=") + Long.toString(value);
        range.addPartition(new RangeEdgePartition(label, value, from, to));
    }

    private void makePartitions(FeatureRange range, long fromVal, long toVal, long stepSize, int arity, boolean isNeg) {
        int fromRemainder = (int)(fromVal % (long)arity);
        long nextFromVal = fromVal - (long)fromRemainder;
        int toRemainder = (int)(toVal % (long)arity);
        long nextToVal = toVal - (long)toRemainder;
        if (nextFromVal == nextToVal) {
            this.addPartitions(range, nextFromVal, stepSize, fromRemainder, toRemainder, isNeg);
        } else {
            if (fromRemainder > 0) {
                this.addPartitions(range, nextFromVal, stepSize, fromRemainder, arity, isNeg);
                fromVal = nextFromVal + (long)arity;
            }
            this.addPartitions(range, nextToVal, stepSize, 0, toRemainder, isNeg);
            this.makePartitions(range, fromVal / (long)arity, toVal / (long)arity, stepSize * (long)arity, arity, isNeg);
        }
    }

    private void addPartitions(FeatureRange range, long part, long partSize, int first, int last, boolean isNeg) {
        for (int i = first; i < last; ++i) {
            range.addPartition(new RangePartition(range.getKey(), (part + (long)i) * partSize, (part + (long)i + 1L) * partSize - 1L, isNeg));
        }
    }

    @Override
    public Predicate process(Predicate predicate, PredicateOptions options) {
        this.processPredicate(predicate, options);
        return predicate;
    }

    private static class RangePruner {
        private long from;
        private long to;

        public RangePruner(FeatureRange range, PredicateOptions options, int arity) {
            this.from = range.getFromInclusive() != null ? range.getFromInclusive().longValue() : options.getAdjustedLowerBound();
            long l = this.to = range.getToInclusive() != null ? range.getToInclusive().longValue() : options.getAdjustedUpperBound();
            if (this.from > options.getUpperBound()) {
                long upperRangeStart = Long.MAX_VALUE - Long.MAX_VALUE % (long)arity - (long)arity;
                if (options.getUpperBound() < upperRangeStart) {
                    this.from = upperRangeStart;
                    this.to = upperRangeStart + (long)arity - 1L;
                } else {
                    this.to = this.from;
                }
            } else if (this.to < options.getLowerBound()) {
                long lowerRangeEnd = Long.MIN_VALUE + ((long)arity - Long.MIN_VALUE % (long)arity);
                if (options.getLowerBound() > lowerRangeEnd) {
                    this.from = lowerRangeEnd - (long)arity + 1L;
                    this.to = lowerRangeEnd;
                } else {
                    this.from = this.to;
                }
            } else {
                if (this.from < options.getLowerBound()) {
                    this.from = options.getAdjustedLowerBound();
                }
                if (this.to > options.getUpperBound()) {
                    this.to = options.getAdjustedUpperBound();
                }
            }
        }

        public long getFrom() {
            return this.from;
        }

        public long getTo() {
            return this.to;
        }
    }
}

