/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.optimization;

import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.FeatureSet;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.search.predicate.optimization.PredicateOptions;
import com.yahoo.search.predicate.optimization.PredicateProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class OrSimplifier
implements PredicateProcessor {
    @Override
    public Predicate process(Predicate predicate, PredicateOptions options) {
        return this.simplifyTree(predicate);
    }

    public Predicate simplifyTree(Predicate predicate) {
        if (predicate instanceof Disjunction) {
            Disjunction disjunction = (Disjunction)predicate;
            List<Predicate> newChildren = disjunction.getOperands().stream().map(this::simplifyTree).toList();
            return OrSimplifier.compressFeatureSets(newChildren);
        }
        if (predicate instanceof Negation) {
            Negation negation = (Negation)predicate;
            negation.setOperand(this.simplifyTree(negation.getOperand()));
            return negation;
        }
        if (predicate instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)predicate;
            List<Predicate> newChildren = conjunction.getOperands().stream().map(this::simplifyTree).toList();
            conjunction.setOperands(newChildren);
            return conjunction;
        }
        return predicate;
    }

    private static Predicate compressFeatureSets(List<Predicate> children) {
        List newChildren = children.stream().filter(p -> !(p instanceof FeatureSet)).collect(Collectors.toCollection(ArrayList::new));
        children.stream().filter(FeatureSet.class::isInstance).map(FeatureSet.class::cast).collect(Collectors.groupingBy(FeatureSet::getKey, Collectors.reducing((f1, f2) -> {
            f1.addValues(f2.getValues());
            return f1;
        }))).values().stream().map(Optional::get).forEach(newChildren::add);
        if (newChildren.size() == 1) {
            return (Predicate)newChildren.get(0);
        }
        return new Disjunction(newChildren);
    }
}

