/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.optimization;

import com.yahoo.document.predicate.BooleanPredicate;
import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.predicate.PredicateOperator;
import com.yahoo.search.predicate.optimization.PredicateOptions;
import com.yahoo.search.predicate.optimization.PredicateProcessor;
import java.util.ArrayList;
import java.util.List;

public class BooleanSimplifier
implements PredicateProcessor {
    public Predicate simplifySubTree(Predicate predicate) {
        if (predicate == null) {
            return null;
        }
        if (predicate instanceof Conjunction) {
            List<Predicate> in = ((PredicateOperator)predicate).getOperands();
            ArrayList<Predicate> out = new ArrayList<Predicate>(in.size());
            for (Predicate operand : in) {
                if (this.isFalse(operand = this.simplifySubTree(operand))) {
                    return new BooleanPredicate(false);
                }
                if (this.isTrue(operand)) continue;
                out.add(operand);
            }
            if (out.size() == 1) {
                return (Predicate)out.get(0);
            }
            if (out.size() == 0) {
                return new BooleanPredicate(true);
            }
            ((Conjunction)predicate).setOperands(out);
        } else if (predicate instanceof Disjunction) {
            List<Predicate> in = ((PredicateOperator)predicate).getOperands();
            ArrayList<Predicate> out = new ArrayList<Predicate>(in.size());
            for (Predicate operand : in) {
                if (this.isTrue(operand = this.simplifySubTree(operand))) {
                    return new BooleanPredicate(true);
                }
                if (this.isFalse(operand)) continue;
                out.add(operand);
            }
            if (out.size() == 1) {
                return (Predicate)out.get(0);
            }
            if (out.size() == 0) {
                return new BooleanPredicate(false);
            }
            ((Disjunction)predicate).setOperands(out);
        } else if (predicate instanceof Negation) {
            Predicate operand = ((Negation)predicate).getOperand();
            if (this.isTrue(operand = this.simplifySubTree(operand))) {
                return new BooleanPredicate(false);
            }
            if (this.isFalse(operand)) {
                return new BooleanPredicate(true);
            }
            ((Negation)predicate).setOperand(operand);
        }
        return predicate;
    }

    private boolean isFalse(Predicate predicate) {
        if (predicate instanceof BooleanPredicate) {
            return !((BooleanPredicate)predicate).getValue();
        }
        return false;
    }

    private boolean isTrue(Predicate predicate) {
        if (predicate instanceof BooleanPredicate) {
            return ((BooleanPredicate)predicate).getValue();
        }
        return false;
    }

    @Override
    public Predicate process(Predicate predicate, PredicateOptions options) {
        return this.simplifySubTree(predicate);
    }
}

