/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.optimization;

import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.search.predicate.optimization.PredicateOptions;
import com.yahoo.search.predicate.optimization.PredicateProcessor;
import java.util.ArrayList;
import java.util.List;

public class NotNodeReorderer
implements PredicateProcessor {
    public boolean processSubTree(Predicate predicate) {
        if (predicate == null) {
            return false;
        }
        if (predicate instanceof Negation) {
            return true;
        }
        if (predicate instanceof Conjunction) {
            List<Predicate> in = ((Conjunction)predicate).getOperands();
            ArrayList<Predicate> out = new ArrayList<Predicate>(in.size());
            ArrayList<Predicate> positiveChildren = new ArrayList<Predicate>(in.size());
            for (Predicate operand : in) {
                if (this.processSubTree(operand)) {
                    out.add(operand);
                    continue;
                }
                positiveChildren.add(operand);
            }
            out.addAll(positiveChildren);
            ((Conjunction)predicate).setOperands(out);
            return positiveChildren.isEmpty();
        }
        if (predicate instanceof Disjunction) {
            List<Predicate> in = ((Disjunction)predicate).getOperands();
            ArrayList<Predicate> out = new ArrayList<Predicate>(in.size());
            ArrayList<Predicate> negativeChildren = new ArrayList<Predicate>(in.size());
            for (Predicate operand : in) {
                if (this.processSubTree(operand)) {
                    negativeChildren.add(operand);
                    continue;
                }
                out.add(operand);
            }
            out.addAll(negativeChildren);
            ((Disjunction)predicate).setOperands(out);
            return !negativeChildren.isEmpty();
        }
        return false;
    }

    @Override
    public Predicate process(Predicate predicate, PredicateOptions options) {
        this.processSubTree(predicate);
        return predicate;
    }
}

