/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.optimization;

import java.util.OptionalLong;

public class PredicateOptions {
    public static final long DEFAULT_LOWER_BOUND = Long.MIN_VALUE;
    public static final long DEFAULT_UPPER_BOUND = Long.MAX_VALUE;
    private final int arity;
    private final long lowerBound;
    private final long upperBound;
    private OptionalLong adjustedLowerBound;
    private OptionalLong adjustedUpperBound;

    public PredicateOptions(int arity, Long lowerBound, Long upperBound) {
        this.arity = arity;
        this.lowerBound = lowerBound == null ? Long.MIN_VALUE : lowerBound;
        this.upperBound = upperBound == null ? Long.MAX_VALUE : upperBound;
        this.adjustedLowerBound = OptionalLong.empty();
        this.adjustedUpperBound = OptionalLong.empty();
    }

    public PredicateOptions(int arity) {
        this(arity, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public int getArity() {
        return this.arity;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public long getAdjustedLowerBound() {
        if (!this.adjustedLowerBound.isPresent()) {
            this.adjustedLowerBound = this.lowerBound == Long.MIN_VALUE ? OptionalLong.of(this.lowerBound) : (this.lowerBound > 0L ? OptionalLong.of(0L) : OptionalLong.of(-PredicateOptions.adjustBound(this.arity, -this.lowerBound)));
        }
        return this.adjustedLowerBound.getAsLong();
    }

    public long getAdjustedUpperBound() {
        if (!this.adjustedUpperBound.isPresent()) {
            this.adjustedUpperBound = this.upperBound == Long.MAX_VALUE ? OptionalLong.of(Long.MAX_VALUE) : (this.upperBound < 0L ? OptionalLong.of(-1L) : OptionalLong.of(PredicateOptions.adjustBound(this.arity, this.upperBound)));
        }
        return this.adjustedUpperBound.getAsLong();
    }

    private static long adjustBound(int arity, long bound) {
        long adjusted = arity;
        long value = bound;
        long max = Long.MAX_VALUE / (long)arity;
        while ((value /= (long)arity) > 0L) {
            if (adjusted > max) {
                return bound;
            }
            adjusted *= (long)arity;
        }
        return adjusted - 1L;
    }
}

