/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.predicate.PredicateOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Disjunction
extends PredicateOperator {
    private List<Predicate> operands;

    public Disjunction(Predicate ... operands) {
        this(List.of(operands));
    }

    public Disjunction(List<? extends Predicate> operands) {
        this.operands = new ArrayList<Predicate>(operands);
    }

    public Disjunction addOperand(Predicate operand) {
        this.operands.add(operand);
        return this;
    }

    public Disjunction addOperands(Collection<? extends Predicate> operands) {
        this.operands.addAll(operands);
        return this;
    }

    public Disjunction setOperands(Collection<? extends Predicate> operands) {
        this.operands.clear();
        this.operands.addAll(operands);
        return this;
    }

    @Override
    public List<Predicate> getOperands() {
        return this.operands;
    }

    @Override
    public Disjunction clone() throws CloneNotSupportedException {
        Disjunction obj = (Disjunction)super.clone();
        obj.operands = new ArrayList<Predicate>(this.operands.size());
        for (Predicate operand : this.operands) {
            obj.operands.add(operand.clone());
        }
        return obj;
    }

    public int hashCode() {
        return this.operands.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Disjunction)) {
            return false;
        }
        Disjunction rhs = (Disjunction)obj;
        return this.operands.equals(rhs.operands);
    }

    @Override
    protected void appendTo(StringBuilder out) {
        Iterator<Predicate> it = this.operands.iterator();
        while (it.hasNext()) {
            Predicate operand = it.next();
            if (operand instanceof Conjunction) {
                out.append('(');
                operand.appendTo(out);
                out.append(')');
            } else {
                operand.appendTo(out);
            }
            if (!it.hasNext()) continue;
            out.append(" or ");
        }
    }
}

