/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.opennlp;

import com.yahoo.language.opennlp.WordCharDetector;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import opennlp.tools.util.normalizer.CharSequenceNormalizer;

public class VespaCharSequenceNormalizer
implements CharSequenceNormalizer {
    private static final VespaCharSequenceNormalizer INSTANCE = new VespaCharSequenceNormalizer();

    public static VespaCharSequenceNormalizer getInstance() {
        return INSTANCE;
    }

    public CharSequence normalize(CharSequence text) {
        if (text.isEmpty()) {
            return text;
        }
        StringBuilder r = text.codePoints().mapMulti(new OnlyLetters()).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append);
        return r;
    }

    static class OnlyLetters
    implements IntStream.IntMapMultiConsumer {
        boolean addSpace = false;

        OnlyLetters() {
        }

        @Override
        public void accept(int codepoint, IntConsumer target) {
            if (WordCharDetector.isWordChar(codepoint)) {
                if (this.addSpace) {
                    target.accept(32);
                    this.addSpace = false;
                }
                target.accept(Character.toLowerCase(codepoint));
            } else {
                this.addSpace = true;
            }
        }
    }
}

