/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.generation;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.OptionalPathNode;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class LanguageModelFieldGeneratorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "42a92d8e0bc63d3f7b674646b7a9b85b";
    public static final String CONFIG_DEF_NAME = "language-model-field-generator";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.llm.generation";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.llm.generation", "providerId string", "promptTemplate string default=\"\"", "promptTemplateFile path optional", "responseFormatType enum {JSON, TEXT} default=JSON", "invalidResponseFormatPolicy enum {DISCARD, WARN, FAIL} default=DISCARD"};
    private final StringNode providerId;
    private final StringNode promptTemplate;
    private final OptionalPathNode promptTemplateFile;
    private final ResponseFormatType responseFormatType;
    private final InvalidResponseFormatPolicy invalidResponseFormatPolicy;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LanguageModelFieldGeneratorConfig(Builder builder) {
        this(builder, true);
    }

    private LanguageModelFieldGeneratorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for language-model-field-generator must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.providerId = builder.providerId == null ? new StringNode() : new StringNode(builder.providerId);
        this.promptTemplate = builder.promptTemplate == null ? new StringNode("") : new StringNode(builder.promptTemplate);
        this.promptTemplateFile = builder.promptTemplateFile == null ? new OptionalPathNode() : new OptionalPathNode(builder.promptTemplateFile);
        this.responseFormatType = builder.responseFormatType == null ? new ResponseFormatType(ResponseFormatType.JSON) : new ResponseFormatType(builder.responseFormatType);
        this.invalidResponseFormatPolicy = builder.invalidResponseFormatPolicy == null ? new InvalidResponseFormatPolicy(InvalidResponseFormatPolicy.DISCARD) : new InvalidResponseFormatPolicy(builder.invalidResponseFormatPolicy);
    }

    public String providerId() {
        return this.providerId.value();
    }

    public String promptTemplate() {
        return this.promptTemplate.value();
    }

    public Optional<Path> promptTemplateFile() {
        return this.promptTemplateFile.value();
    }

    public ResponseFormatType.Enum responseFormatType() {
        return (ResponseFormatType.Enum)((Object)this.responseFormatType.value());
    }

    public InvalidResponseFormatPolicy.Enum invalidResponseFormatPolicy() {
        return (InvalidResponseFormatPolicy.Enum)((Object)this.invalidResponseFormatPolicy.value());
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LanguageModelFieldGeneratorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("providerId"));
        private String providerId = null;
        private String promptTemplate = null;
        private Optional<FileReference> promptTemplateFile = Optional.empty();
        private ResponseFormatType.Enum responseFormatType = null;
        private InvalidResponseFormatPolicy.Enum invalidResponseFormatPolicy = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LanguageModelFieldGeneratorConfig config) {
            this.providerId(config.providerId());
            this.promptTemplate(config.promptTemplate());
            this.promptTemplateFile(config.promptTemplateFile.getFileReference());
            this.responseFormatType(config.responseFormatType());
            this.invalidResponseFormatPolicy(config.invalidResponseFormatPolicy());
        }

        private Builder override(Builder __superior) {
            if (__superior.providerId != null) {
                this.providerId(__superior.providerId);
            }
            if (__superior.promptTemplate != null) {
                this.promptTemplate(__superior.promptTemplate);
            }
            if (__superior.promptTemplateFile != null) {
                this.promptTemplateFile(__superior.promptTemplateFile);
            }
            if (__superior.responseFormatType != null) {
                this.responseFormatType(__superior.responseFormatType);
            }
            if (__superior.invalidResponseFormatPolicy != null) {
                this.invalidResponseFormatPolicy(__superior.invalidResponseFormatPolicy);
            }
            return this;
        }

        public Builder providerId(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.providerId = __value;
            this.__uninitialized.remove("providerId");
            return this;
        }

        public Builder promptTemplate(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.promptTemplate = __value;
            return this;
        }

        public Builder promptTemplateFile(Optional<FileReference> __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.promptTemplateFile = __value;
            this.__uninitialized.remove("promptTemplateFile");
            return this;
        }

        private Builder promptTemplateFile(FileReference __value) {
            return this.promptTemplateFile(Optional.of(__value));
        }

        public Builder responseFormatType(ResponseFormatType.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.responseFormatType = __value;
            return this;
        }

        private Builder responseFormatType(String __value) {
            return this.responseFormatType(ResponseFormatType.Enum.valueOf(__value));
        }

        public Builder invalidResponseFormatPolicy(InvalidResponseFormatPolicy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.invalidResponseFormatPolicy = __value;
            return this;
        }

        private Builder invalidResponseFormatPolicy(String __value) {
            return this.invalidResponseFormatPolicy(InvalidResponseFormatPolicy.Enum.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LanguageModelFieldGeneratorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LanguageModelFieldGeneratorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LanguageModelFieldGeneratorConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LanguageModelFieldGeneratorConfig build() {
            return new LanguageModelFieldGeneratorConfig(this);
        }
    }

    public static final class ResponseFormatType
    extends EnumNode<Enum> {
        public static final Enum JSON = Enum.JSON;
        public static final Enum TEXT = Enum.TEXT;

        public ResponseFormatType() {
            this.value = null;
        }

        public ResponseFormatType(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            JSON,
            TEXT;

        }
    }

    public static final class InvalidResponseFormatPolicy
    extends EnumNode<Enum> {
        public static final Enum DISCARD = Enum.DISCARD;
        public static final Enum WARN = Enum.WARN;
        public static final Enum FAIL = Enum.FAIL;

        public InvalidResponseFormatPolicy() {
            this.value = null;
        }

        public InvalidResponseFormatPolicy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            DISCARD,
            WARN,
            FAIL;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

