/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.api.annotations.Beta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Beta
class JsonSchemaToGrammar {
    private static final String SPACE_RULE = "| \" \" | \"\\n\" [ \\t]{0,20}";
    private static final Map<String, BuiltinRule> PRIMITIVE_RULES = Map.ofEntries(Map.entry("boolean", new BuiltinRule("(\"true\" | \"false\") space", List.of())), Map.entry("decimal-part", new BuiltinRule("[0-9]{1,16}", List.of())), Map.entry("integral-part", new BuiltinRule("[0] | [1-9] [0-9]{0,15}", List.of())), Map.entry("number", new BuiltinRule("(\"-\"? integral-part) (\".\" decimal-part)? ([eE] [-+]? integral-part)? space", List.of("integral-part", "decimal-part"))), Map.entry("integer", new BuiltinRule("(\"-\"? integral-part) space", List.of("integral-part"))), Map.entry("value", new BuiltinRule("object | array | string | number | boolean | null", List.of("object", "array", "string", "number", "boolean", "null"))), Map.entry("object", new BuiltinRule("\"{\" space ( string \":\" space value (\",\" space string \":\" space value)* )? \"}\" space", List.of("string", "value"))), Map.entry("array", new BuiltinRule("\"[\" space ( value (\",\" space value)* )? \"]\" space", List.of("value"))), Map.entry("uuid", new BuiltinRule("\"\\\"\" [0-9a-fA-F]{8} \"-\" [0-9a-fA-F]{4} \"-\" [0-9a-fA-F]{4} \"-\" [0-9a-fA-F]{4} \"-\" [0-9a-fA-F]{12} \"\\\"\" space", List.of())), Map.entry("char", new BuiltinRule("[^\"\\\\\\x7F\\x00-\\x1F] | [\\\\] ([\"\\\\bfnrt] | \"u\" [0-9a-fA-F]{4})", List.of())), Map.entry("string", new BuiltinRule("\"\\\"\" char* \"\\\"\" space", List.of("char"))), Map.entry("null", new BuiltinRule("\"null\" space", List.of())));
    private static final Map<String, BuiltinRule> FORMATTED_STRING_RULES = Map.of("date", new BuiltinRule("[0-9]{4} \"-\" ( [0] [1-9] | [1] [0-2] ) \"-\" ( [0] [1-9] | [1-2] [0-9] | [3] [0-1] )", List.of()), "time", new BuiltinRule("([01] [0-9] | [2] [0-3]) \":\" [0-5] [0-9] \":\" [0-5] [0-9] ( \".\" [0-9]{3} )? ( \"Z\" | ( \"+\" | \"-\" ) ( [01] [0-9] | [2] [0-3] ) \":\" [0-5] [0-9] )", List.of()), "date-time", new BuiltinRule("date \"T\" time", List.of("date", "time")), "date-string", new BuiltinRule("\"\\\"\" date \"\\\"\" space", List.of("date")), "time-string", new BuiltinRule("\"\\\"\" time \"\\\"\" space", List.of("time")), "date-time-string", new BuiltinRule("\"\\\"\" date-time \"\\\"\" space", List.of("date-time")));
    private static final Set<String> RESERVED_NAMES = new HashSet<String>();
    private static final Pattern INVALID_RULE_CHARS_RE;
    private static final Pattern GRAMMAR_LITERAL_ESCAPE_RE;
    private static final Map<String, String> GRAMMAR_LITERAL_ESCAPES;
    private final List<Visitor> visitors = List.of(new OneOfOrAnyOfVisitor(), new UnionOfSchemasVisitor(), new ConstVisitor(), new EnumVisitor(), new ObjectWithAdditionalPropertiesVisitor(), new ObjectWithAllOfVisitor(), new ArrayVisitor(), new UuidVisitor(), new FormattedStringVisitor(), new StringWithMinMaxLengthVisitor(), new IntegerWithMinMaxVisitor(), new ObjectVisitor(), new PrimitiveVisitor());
    private final Map<String, String> rules = new HashMap<String, String>();

    public static String convert(String schema) {
        JsonNode rootSchema;
        ObjectMapper mapper = new ObjectMapper();
        try {
            rootSchema = mapper.readTree(schema);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        JsonSchemaToGrammar converter = new JsonSchemaToGrammar();
        converter.visit(rootSchema, null);
        return converter.formatGrammar() + "\n";
    }

    public JsonSchemaToGrammar() {
        this.rules.put("space", SPACE_RULE);
    }

    private String addRule(String name, String content) {
        Object finalName = INVALID_RULE_CHARS_RE.matcher(name).replaceAll("-");
        if (this.rules.containsKey(finalName) && !this.rules.get(finalName).equals(content)) {
            int index = 0;
            while (this.rules.containsKey((String)finalName + index) && !this.rules.get((String)finalName + index).equals(content)) {
                ++index;
            }
            finalName = (String)finalName + index;
        }
        this.rules.put((String)finalName, content);
        return finalName;
    }

    private String visit(JsonNode schema, String baseName) {
        Object name = baseName == null ? "root" : (RESERVED_NAMES.contains(baseName) ? baseName + "-" : baseName);
        for (Visitor visitor : this.visitors) {
            Optional<String> ruleContent = visitor.maybeVisit(schema, baseName, (String)name);
            if (!ruleContent.isPresent()) continue;
            return ruleContent.get();
        }
        throw new IllegalArgumentException("Unrecognized schema: " + String.valueOf(schema));
    }

    private String getTypeText(JsonNode schema) {
        if (schema.has("type")) {
            return schema.get("type").asText();
        }
        return null;
    }

    private String getFormatText(JsonNode schema) {
        if (schema.has("format")) {
            return schema.get("format").asText();
        }
        return null;
    }

    private String generateRepetition(String itemRule, int minItems, Integer maxItems, String separatorRule) {
        if (minItems == 0 && maxItems != null && maxItems == 1) {
            return itemRule + "?";
        }
        if (separatorRule == null) {
            if (minItems == 1 && maxItems == null) {
                return itemRule + "+";
            }
            if (minItems == 0 && maxItems == null) {
                return itemRule + "*";
            }
            return itemRule + "{" + minItems + "," + String.valueOf(maxItems != null ? maxItems : "") + "}";
        }
        String result = itemRule + " " + this.generateRepetition("(" + separatorRule + " " + itemRule + ")", minItems > 0 ? minItems - 1 : 0, maxItems != null ? Integer.valueOf(maxItems - 1) : null, null);
        return minItems == 0 ? "(" + result + ")?" : result;
    }

    public static String generateDigitRange(char fromChar, char toChar) {
        if (fromChar == toChar) {
            return "[" + fromChar + "]";
        }
        return "[" + fromChar + "-" + toChar + "]";
    }

    public static String generateMoreDigits(int minDigits, int maxDigits) {
        StringBuilder content = new StringBuilder();
        content.append("[0-9]");
        if (minDigits == maxDigits && minDigits == 1) {
            return content.toString();
        }
        content.append("{").append(minDigits);
        if (maxDigits != minDigits) {
            content.append(",");
            if (maxDigits != Integer.MAX_VALUE) {
                content.append(maxDigits);
            }
        }
        content.append("}");
        return content.toString();
    }

    public static String generateUniformRange(String fromStr, String toStr) {
        int samePrefixIndex;
        StringBuilder content = new StringBuilder();
        for (samePrefixIndex = 0; samePrefixIndex < fromStr.length() && fromStr.charAt(samePrefixIndex) == toStr.charAt(samePrefixIndex); ++samePrefixIndex) {
        }
        String samePrefix = fromStr.substring(0, samePrefixIndex);
        if (samePrefix.length() == 1) {
            content.append("[").append(samePrefix).append("]");
        } else if (samePrefix.length() > 1) {
            content.append("\"").append(samePrefix).append("\"");
        }
        if (samePrefixIndex < fromStr.length()) {
            int subLen;
            if (samePrefixIndex > 0) {
                content.append(" ");
            }
            if ((subLen = fromStr.length() - samePrefixIndex - 1) > 0) {
                String fromSub = fromStr.substring(samePrefixIndex + 1);
                String toSub = toStr.substring(samePrefixIndex + 1);
                String subZeros = "0".repeat(subLen);
                String subNines = "9".repeat(subLen);
                boolean toReached = false;
                content.append("(");
                if (fromSub.equals(subZeros)) {
                    content.append(JsonSchemaToGrammar.generateDigitRange(fromStr.charAt(samePrefixIndex), (char)(toStr.charAt(samePrefixIndex) - '\u0001'))).append(" ").append(JsonSchemaToGrammar.generateMoreDigits(subLen, subLen));
                } else {
                    content.append("[").append(fromStr.charAt(samePrefixIndex)).append("] ").append("(").append(JsonSchemaToGrammar.generateUniformRange(fromSub, subNines)).append(")");
                    if (fromStr.charAt(samePrefixIndex) < toStr.charAt(samePrefixIndex) - '\u0001') {
                        content.append(" | ");
                        if (toSub.equals(subNines)) {
                            content.append(JsonSchemaToGrammar.generateDigitRange((char)(fromStr.charAt(samePrefixIndex) + '\u0001'), toStr.charAt(samePrefixIndex)));
                            toReached = true;
                        } else {
                            content.append(JsonSchemaToGrammar.generateDigitRange((char)(fromStr.charAt(samePrefixIndex) + '\u0001'), (char)(toStr.charAt(samePrefixIndex) - '\u0001')));
                        }
                        content.append(" ");
                        content.append(JsonSchemaToGrammar.generateMoreDigits(subLen, subLen));
                    }
                }
                if (!toReached) {
                    content.append(" | ").append(JsonSchemaToGrammar.generateDigitRange(toStr.charAt(samePrefixIndex), toStr.charAt(samePrefixIndex))).append(" ").append(JsonSchemaToGrammar.generateUniformRange(subZeros, toSub));
                }
                content.append(")");
            } else {
                content.append("[").append(fromStr.charAt(samePrefixIndex)).append("-").append(toStr.charAt(samePrefixIndex)).append("]");
            }
        }
        return content.toString();
    }

    private String generateMinMaxInt(Integer min_value, Integer max_value, int decimals_left, boolean top_level) {
        StringBuilder content = new StringBuilder();
        if (min_value != null && max_value != null) {
            if (min_value < 0 && max_value < 0) {
                content.append("\"-\" (").append(this.generateMinMaxInt(-max_value.intValue(), -min_value.intValue(), decimals_left, true)).append(")");
                return content.toString();
            }
            if (min_value < 0) {
                content.append("\"-\" (").append(this.generateMinMaxInt(0, -min_value.intValue(), decimals_left, true)).append(") | ");
                min_value = 0;
            }
            Object min_s = Integer.toString(min_value);
            String max_s = Integer.toString(max_value);
            int minDigits = ((String)min_s).length();
            int maxDigits = max_s.length();
            for (int digits = minDigits; digits < maxDigits; ++digits) {
                content.append(JsonSchemaToGrammar.generateUniformRange((String)min_s, "9".repeat(digits)));
                min_s = "1" + "0".repeat(digits);
                content.append(" | ");
            }
            content.append(JsonSchemaToGrammar.generateUniformRange((String)min_s, max_s));
            return content.toString();
        }
        if (min_value != null) {
            if (min_value < 0) {
                content.append("\"-\" (").append(this.generateMinMaxInt(null, -min_value.intValue(), decimals_left, false)).append(") | [0] | [1-9] ").append(JsonSchemaToGrammar.generateMoreDigits(0, decimals_left - 1));
            } else if (min_value == 0) {
                if (top_level) {
                    content.append("[0] | [1-9] ").append(JsonSchemaToGrammar.generateMoreDigits(0, decimals_left - 1));
                } else {
                    content.append(JsonSchemaToGrammar.generateMoreDigits(1, decimals_left));
                }
            } else if (min_value <= 9) {
                String rangeStart;
                String c = Integer.toString(min_value);
                String string = rangeStart = top_level ? "1" : "0";
                if (c.compareTo(rangeStart) > 0) {
                    content.append(JsonSchemaToGrammar.generateUniformRange(rangeStart, Character.toString((char)(c.charAt(0) - '\u0001')))).append(" ").append(JsonSchemaToGrammar.generateMoreDigits(1, decimals_left - 1)).append(" | ");
                }
                content.append(JsonSchemaToGrammar.generateUniformRange(c, "9")).append(" ").append(JsonSchemaToGrammar.generateMoreDigits(0, decimals_left - 1));
            } else {
                String min_s = Integer.toString(min_value);
                int length = min_s.length();
                char c = min_s.charAt(0);
                if (c > '1') {
                    content.append(JsonSchemaToGrammar.generateUniformRange(top_level ? "1" : "0", Character.toString((char)(c - '\u0001')))).append(" ").append(JsonSchemaToGrammar.generateMoreDigits(length, decimals_left - 1)).append(" | ");
                }
                content.append(JsonSchemaToGrammar.generateUniformRange(Character.toString(c), Character.toString(c))).append(" (").append(this.generateMinMaxInt(Integer.parseInt(min_s.substring(1)), null, decimals_left - 1, false)).append(")");
                if (c < '9') {
                    content.append(" | ").append(JsonSchemaToGrammar.generateUniformRange(Character.toString((char)(c + '\u0001')), "9")).append(" ").append(JsonSchemaToGrammar.generateMoreDigits(length - 1, decimals_left - 1));
                }
            }
            return content.toString();
        }
        if (max_value != null) {
            if (max_value >= 0) {
                if (top_level) {
                    content.append("\"-\" [1-9] ").append(JsonSchemaToGrammar.generateMoreDigits(0, decimals_left - 1)).append(" | ");
                }
                content.append(this.generateMinMaxInt(0, max_value, decimals_left, true));
            } else {
                content.append("\"-\" (").append(this.generateMinMaxInt(-max_value.intValue(), null, decimals_left, false)).append(")");
            }
            return content.toString();
        }
        throw new RuntimeException("At least one of min_value or max_value must be set");
    }

    private String formatLiteral(String literal) {
        String escaped = GRAMMAR_LITERAL_ESCAPE_RE.matcher(literal).replaceAll(m -> GRAMMAR_LITERAL_ESCAPES.getOrDefault(m.group(0), m.group(0)));
        return "\"" + escaped + "\"";
    }

    private String generateConstant(JsonNode value) {
        String valueStr = value.toString().replace("\"", "\\\"");
        return this.formatLiteral(valueStr);
    }

    private String generateNotStrings(Set<String> strings) {
        TrieNode trie = new TrieNode();
        for (String s : strings) {
            trie.insert(s);
        }
        String charRule = this.addPrimitive("char", PRIMITIVE_RULES.get("char"));
        StringBuilder content = new StringBuilder();
        content.append("[\"] ( ");
        this.generateNotStringsVisit(trie, charRule, content);
        content.append(" )").append(trie.isEndOfString ? "" : "?").append(" [\"] space");
        return content.toString();
    }

    private void generateNotStringsVisit(TrieNode node, String charRule, StringBuilder content) {
        ArrayList<String> rejects = new ArrayList<String>();
        boolean first = true;
        for (Character c : node.children.keySet().stream().sorted().toList()) {
            TrieNode child = node.children.get(c);
            rejects.add(c.toString());
            if (!first) {
                content.append(" | ");
            }
            content.append("[").append(c).append("]");
            if (!child.children.isEmpty()) {
                content.append(" (");
                this.generateNotStringsVisit(child, charRule, content);
                content.append(")");
            } else if (child.isEndOfString) {
                content.append(" ").append(charRule).append("+");
            }
            first = false;
        }
        if (!node.children.isEmpty()) {
            if (!first) {
                content.append(" | ");
            }
            content.append("[^\"").append(String.join((CharSequence)"", rejects)).append("] ").append(charRule).append("*");
        }
    }

    private String generateUnion(String name, List<JsonNode> altSchemas) {
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < altSchemas.size(); ++i) {
            JsonNode altSchema = altSchemas.get(i);
            if (i > 0) {
                content.append(" | ");
            }
            content.append(this.visit(altSchema, (String)(name == null ? "alternative-" : name + "-") + i));
        }
        return content.toString();
    }

    private String addPrimitive(String name, BuiltinRule builtinRule) {
        String rule = this.addRule(name, builtinRule.content);
        for (String dep : builtinRule.dependencies) {
            BuiltinRule depRule;
            BuiltinRule builtinRule2 = depRule = PRIMITIVE_RULES.containsKey(dep) ? PRIMITIVE_RULES.get(dep) : FORMATTED_STRING_RULES.get(dep);
            if (depRule == null) {
                throw new IllegalArgumentException("Rule " + dep + " not known");
            }
            if (this.rules.containsKey(dep)) continue;
            this.addPrimitive(dep, depRule);
        }
        return rule;
    }

    private String generateObject(List<Map.Entry<String, JsonNode>> properties, Set<String> required, String name, JsonNode additionalProperties) {
        HashMap<String, String> propertyRules = new HashMap<String, String>();
        for (Map.Entry<String, JsonNode> property : properties) {
            String propertyKey = property.getKey();
            JsonNode propertySchema = property.getValue();
            String propertyValue = this.visit(propertySchema, (String)(name == null ? "" : name + "-") + propertyKey);
            String propertyRuleName = (String)(name == null ? "" : name + "-") + propertyKey + "-kv";
            String propertyRuleContent = this.formatLiteral("\\\"" + propertyKey + "\\\"") + " space \":\" space " + propertyValue;
            String propertyRule = this.addRule(propertyRuleName, propertyRuleContent);
            propertyRules.put(propertyKey, propertyRule);
        }
        List<String> requiredProperties = properties.stream().map(Map.Entry::getKey).filter(required::contains).toList();
        List optionalProperties = properties.stream().map(Map.Entry::getKey).filter(k -> !required.contains(k)).collect(Collectors.toList());
        if (additionalProperties != null && (!additionalProperties.isBoolean() || additionalProperties.asBoolean())) {
            String subName = (String)(name == null ? "" : name + "-") + "additional";
            String valueRule = additionalProperties.isObject() ? this.visit(additionalProperties, subName + "-value") : this.addPrimitive("value", PRIMITIVE_RULES.get("value"));
            String keyRule = properties.isEmpty() ? this.addPrimitive("string", PRIMITIVE_RULES.get("string")) : this.addRule(subName + "-k", this.generateNotStrings(properties.stream().map(Map.Entry::getKey).collect(Collectors.toSet())));
            propertyRules.put("*", this.addRule(subName + "-kv", keyRule + " \":\" space " + valueRule));
            optionalProperties.add("*");
        }
        StringBuilder content = new StringBuilder("\"{\" space ");
        content.append(requiredProperties.stream().map(propertyRules::get).collect(Collectors.joining(" \",\" space ")));
        if (!optionalProperties.isEmpty()) {
            content.append(" (");
            if (!requiredProperties.isEmpty()) {
                content.append(" \",\" space ( ");
            }
            content.append(optionalProperties.stream().map(k -> this.generateObjectRuleGetRecursiveRefs(name, propertyRules, optionalProperties.subList(optionalProperties.indexOf(k), optionalProperties.size()), false)).collect(Collectors.joining(" | ")));
            if (!requiredProperties.isEmpty()) {
                content.append(" )");
            }
            content.append(" )?");
        }
        content.append(" \"}\" space");
        return content.toString();
    }

    private String generateObjectRuleGetRecursiveRefs(String name, Map<String, String> propertyRules, List<String> properties, boolean firstIsOptional) {
        String headProperty = properties.get(0);
        List<String> tailProperties = properties.subList(1, properties.size());
        String headPropertyRule = propertyRules.get(headProperty);
        String commaRef = "( \",\" space " + headPropertyRule + " )";
        StringBuilder content = new StringBuilder();
        if (firstIsOptional) {
            content.append(commaRef);
            if (headProperty.equals("*")) {
                content.append("*");
            } else {
                content.append("?");
            }
        } else {
            content.append(headPropertyRule);
            if (headProperty.equals("*")) {
                content.append(" ").append(commaRef).append("*");
            }
        }
        if (!tailProperties.isEmpty()) {
            content.append(" ");
            String subruleName = (String)(name == null ? "" : name + "-") + headProperty + "-rest";
            String subruleContent = this.generateObjectRuleGetRecursiveRefs(name, propertyRules, tailProperties, true);
            String subrule = this.addRule(subruleName, subruleContent);
            content.append(subrule);
        }
        return content.toString();
    }

    private String formatGrammar() {
        return this.rules.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(kv -> (String)kv.getKey() + " ::= " + (String)kv.getValue()).collect(Collectors.joining("\n"));
    }

    static {
        RESERVED_NAMES.add("root");
        RESERVED_NAMES.add("dot");
        RESERVED_NAMES.addAll(PRIMITIVE_RULES.keySet());
        RESERVED_NAMES.addAll(FORMATTED_STRING_RULES.keySet());
        INVALID_RULE_CHARS_RE = Pattern.compile("[^a-zA-Z0-9-]+");
        GRAMMAR_LITERAL_ESCAPE_RE = Pattern.compile("[\r\n\"]");
        GRAMMAR_LITERAL_ESCAPES = Map.of("\r", "\\r", "\n", "\\n", "\"", "\\\"", "-", "\\-", "]", "\\]");
    }

    private static interface Visitor {
        public Optional<String> maybeVisit(JsonNode var1, String var2, String var3);
    }

    private class OneOfOrAnyOfVisitor
    implements Visitor {
        private OneOfOrAnyOfVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            if (schema.has("oneOf") || schema.has("anyOf")) {
                JsonNode oneNode = schema.has("oneOf") ? schema.get("oneOf") : schema.get("anyOf");
                ArrayList<JsonNode> oneChildren = new ArrayList<JsonNode>();
                oneNode.elements().forEachRemaining(oneChildren::add);
                String rule = JsonSchemaToGrammar.this.addRule(name, JsonSchemaToGrammar.this.generateUnion(baseName, oneChildren));
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class UnionOfSchemasVisitor
    implements Visitor {
        private UnionOfSchemasVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            JsonNode type = schema.get("type");
            if (type != null && type.isArray()) {
                ArrayList<JsonNode> modSchemas = new ArrayList<JsonNode>();
                Iterator it = type.elements();
                while (it.hasNext()) {
                    JsonNode t = (JsonNode)it.next();
                    JsonNode schemaCopy = schema.deepCopy();
                    ((ObjectNode)schemaCopy).set("type", t);
                    modSchemas.add(schemaCopy);
                }
                String rule = JsonSchemaToGrammar.this.addRule(name, JsonSchemaToGrammar.this.generateUnion(baseName, modSchemas));
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class ConstVisitor
    implements Visitor {
        private ConstVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            if (schema.has("const")) {
                String rule = JsonSchemaToGrammar.this.addRule(name, JsonSchemaToGrammar.this.generateConstant(schema.get("const")) + " space");
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class EnumVisitor
    implements Visitor {
        private EnumVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            if (schema.has("enum")) {
                StringBuilder content = new StringBuilder();
                content.append("(");
                for (int i = 0; i < schema.get("enum").size(); ++i) {
                    if (i > 0) {
                        content.append(" | ");
                    }
                    content.append(JsonSchemaToGrammar.this.generateConstant(schema.get("enum").get(i)));
                }
                content.append(") space");
                String rule = JsonSchemaToGrammar.this.addRule(name, content.toString());
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class ObjectWithAdditionalPropertiesVisitor
    implements Visitor {
        private ObjectWithAdditionalPropertiesVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            String typeText = JsonSchemaToGrammar.this.getTypeText(schema);
            if ((typeText == null || typeText.equals("object")) && (schema.has("properties") || schema.has("additionalProperties") && !schema.get("additionalProperties").asBoolean())) {
                HashSet<String> required = new HashSet<String>();
                if (schema.has("required")) {
                    schema.get("required").forEach(node -> required.add(node.asText()));
                }
                ArrayList<Map.Entry<String, JsonNode>> properties = new ArrayList<Map.Entry<String, JsonNode>>();
                if (schema.has("properties")) {
                    schema.get("properties").fields().forEachRemaining(properties::add);
                }
                String rule = JsonSchemaToGrammar.this.addRule(name, JsonSchemaToGrammar.this.generateObject(properties, required, baseName, schema.get("additionalProperties")));
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class ObjectWithAllOfVisitor
    implements Visitor {
        private ObjectWithAllOfVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            String typeText = JsonSchemaToGrammar.this.getTypeText(schema);
            if ((typeText == null || typeText.equals("object")) && schema.has("allOf")) {
                HashSet<String> required = new HashSet<String>();
                ArrayList<Map.Entry<String, JsonNode>> properties = new ArrayList<Map.Entry<String, JsonNode>>();
                BiConsumer<JsonNode, Boolean> addComponent = (compNode, isRequired) -> {
                    if (compNode.has("properties")) {
                        compNode.get("properties").fields().forEachRemaining(properties::add);
                        if (isRequired.booleanValue()) {
                            compNode.get("properties").fieldNames().forEachRemaining(required::add);
                        }
                    }
                };
                for (JsonNode allOfChildNode : schema.get("allOf")) {
                    if (allOfChildNode.has("anyOf")) {
                        for (JsonNode anyOfChild : allOfChildNode.get("anyOf")) {
                            addComponent.accept(anyOfChild, false);
                        }
                        continue;
                    }
                    addComponent.accept(allOfChildNode, true);
                }
                String rule = JsonSchemaToGrammar.this.addRule(name, JsonSchemaToGrammar.this.generateObject(properties, required, baseName, null));
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class ArrayVisitor
    implements Visitor {
        private ArrayVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            String typeText = JsonSchemaToGrammar.this.getTypeText(schema);
            if ((typeText == null || typeText.equals("array")) && (schema.has("items") || schema.has("prefixItems"))) {
                JsonNode items;
                JsonNode jsonNode = items = schema.has("items") ? schema.get("items") : schema.get("prefixItems");
                if (items.isArray()) {
                    StringBuilder content = new StringBuilder();
                    content.append("\"[\" space ");
                    for (int i = 0; i < items.size(); ++i) {
                        if (i > 0) {
                            content.append(" \",\" space ");
                        }
                        JsonNode item = items.get(i);
                        String itemRuleName = (String)(baseName == null ? "" : baseName + "-") + "tuple-" + i;
                        String itemRule = JsonSchemaToGrammar.this.visit(item, itemRuleName);
                        content.append(itemRule);
                    }
                    content.append(" \"]\" space");
                    String rule = JsonSchemaToGrammar.this.addRule(name, content.toString());
                    return Optional.of(rule);
                }
                String itemRuleName = (String)(baseName == null ? "" : baseName + "-") + "item";
                String visitedItemRuleName = JsonSchemaToGrammar.this.visit(items, itemRuleName);
                int minItems = schema.has("minItems") ? schema.get("minItems").asInt() : 0;
                Integer maxItems = schema.has("maxItems") ? Integer.valueOf(schema.get("maxItems").asInt()) : null;
                String content = "\"[\" space " + JsonSchemaToGrammar.this.generateRepetition(visitedItemRuleName, minItems, maxItems, "\",\" space") + " \"]\" space";
                String rule = JsonSchemaToGrammar.this.addRule(name, content);
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class UuidVisitor
    implements Visitor {
        private UuidVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            String typeText = JsonSchemaToGrammar.this.getTypeText(schema);
            String formatText = JsonSchemaToGrammar.this.getFormatText(schema);
            if ((typeText == null || typeText.equals("string")) && formatText != null && formatText.matches("^uuid[1-5]?$")) {
                String rule = JsonSchemaToGrammar.this.addPrimitive(name.equals("root") ? "root" : formatText, PRIMITIVE_RULES.get("uuid"));
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class FormattedStringVisitor
    implements Visitor {
        private FormattedStringVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            String typeText = JsonSchemaToGrammar.this.getTypeText(schema);
            String formatText = JsonSchemaToGrammar.this.getFormatText(schema);
            if ((typeText == null || typeText.equals("string")) && FORMATTED_STRING_RULES.containsKey(formatText + "-string")) {
                String primitiveName = formatText + "-string";
                String primitive = JsonSchemaToGrammar.this.addPrimitive(primitiveName, FORMATTED_STRING_RULES.get(primitiveName));
                String rule = JsonSchemaToGrammar.this.addRule(name, primitive);
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class StringWithMinMaxLengthVisitor
    implements Visitor {
        private StringWithMinMaxLengthVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            String typeText = JsonSchemaToGrammar.this.getTypeText(schema);
            if (typeText != null && typeText.equals("string") && (schema.has("minLength") || schema.has("maxLength"))) {
                String charRule = JsonSchemaToGrammar.this.addPrimitive("char", PRIMITIVE_RULES.get("char"));
                int minLen = schema.has("minLength") ? schema.get("minLength").asInt() : 0;
                Integer maxLen = schema.has("maxLength") ? Integer.valueOf(schema.get("maxLength").asInt()) : null;
                String conent = "\"\\\"\" " + JsonSchemaToGrammar.this.generateRepetition(charRule, minLen, maxLen, null) + " \"\\\"\" space";
                String rule = JsonSchemaToGrammar.this.addRule(name, conent);
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class IntegerWithMinMaxVisitor
    implements Visitor {
        private IntegerWithMinMaxVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            String typeText = JsonSchemaToGrammar.this.getTypeText(schema);
            if ((typeText == null || typeText.equals("integer")) && (schema.has("minimum") || schema.has("exclusiveMinimum") || schema.has("maximum") || schema.has("exclusiveMaximum"))) {
                Integer minValue = null;
                Integer maxValue = null;
                if (schema.has("minimum")) {
                    minValue = schema.get("minimum").asInt();
                } else if (schema.has("exclusiveMinimum")) {
                    minValue = schema.get("exclusiveMinimum").asInt() + 1;
                }
                if (schema.has("maximum")) {
                    maxValue = schema.get("maximum").asInt();
                } else if (schema.has("exclusiveMaximum")) {
                    maxValue = schema.get("exclusiveMaximum").asInt() - 1;
                }
                String content = "(" + JsonSchemaToGrammar.this.generateMinMaxInt(minValue, maxValue, 16, true) + ") space";
                String rule = JsonSchemaToGrammar.this.addRule(name, content);
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class ObjectVisitor
    implements Visitor {
        private ObjectVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            String typeText = JsonSchemaToGrammar.this.getTypeText(schema);
            if (typeText == null || typeText.equals("object") || schema.isEmpty()) {
                String rule = JsonSchemaToGrammar.this.addRule(name, JsonSchemaToGrammar.this.addPrimitive("object", PRIMITIVE_RULES.get("object")));
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private class PrimitiveVisitor
    implements Visitor {
        private PrimitiveVisitor() {
        }

        @Override
        public Optional<String> maybeVisit(JsonNode schema, String baseName, String name) {
            String schemaTypeText = JsonSchemaToGrammar.this.getTypeText(schema);
            if (schemaTypeText != null && PRIMITIVE_RULES.containsKey(schemaTypeText)) {
                String rule = JsonSchemaToGrammar.this.addPrimitive(name.equals("root") ? "root" : schemaTypeText, PRIMITIVE_RULES.get(schemaTypeText));
                return Optional.of(rule);
            }
            return Optional.empty();
        }
    }

    private static class TrieNode {
        private final Map<Character, TrieNode> children = new HashMap<Character, TrieNode>();
        private boolean isEndOfString = false;

        private TrieNode() {
        }

        public void insert(String string) {
            TrieNode node = this;
            for (char c : string.toCharArray()) {
                node = node.children.computeIfAbsent(Character.valueOf(c), k -> new TrieNode());
            }
            node.isEndOfString = true;
        }
    }

    private record BuiltinRule(String content, List<String> dependencies) {
    }
}

