/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Concat;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;
import java.util.Optional;

public class OnnxConcat
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;
    private String concatDimensionName;
    private int concatDimensionIndex;

    public OnnxConcat(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
        if (attributeMap.get("axis").isEmpty()) {
            throw new IllegalArgumentException("OnnxConcat in " + this.name + ": Required attribute 'axis' is missing.");
        }
        this.concatDimensionIndex = (int)attributeMap.get("axis").get().asDouble();
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.inputs.stream().map(IntermediateOperation::type).allMatch(Optional::isPresent)) {
            return null;
        }
        OrderedTensorType aType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        if (this.concatDimensionIndex < 0) {
            this.concatDimensionIndex = aType.dimensions().size() + this.concatDimensionIndex;
        }
        long concatDimSize = aType.dimensions().get(this.concatDimensionIndex).size().orElse(-1L);
        for (int i = 1; i < this.inputs.size(); ++i) {
            OrderedTensorType bType = ((IntermediateOperation)this.inputs.get(i)).type().get();
            if (bType.rank() != aType.rank()) {
                throw new IllegalArgumentException("OnnxConcat in " + this.name + ": Inputs must have the same rank.");
            }
            for (int j = 0; j < aType.rank(); ++j) {
                long dimSizeA = aType.dimensions().get(j).size().orElse(-1L);
                long dimSizeB = bType.dimensions().get(j).size().orElse(-1L);
                if (j == this.concatDimensionIndex) {
                    concatDimSize += dimSizeB;
                    continue;
                }
                if (dimSizeA == dimSizeB) continue;
                throw new IllegalArgumentException("OnnxConcat in " + this.name + ": input dimension " + j + " differs in input tensors.");
            }
        }
        OrderedTensorType.Builder typeBuilder = new OrderedTensorType.Builder(this.resultValueType());
        int dimensionIndex = 0;
        for (TensorType.Dimension dimension : aType.dimensions()) {
            if (dimensionIndex == this.concatDimensionIndex) {
                this.concatDimensionName = dimension.name();
                typeBuilder.add(TensorType.Dimension.indexed((String)this.concatDimensionName, (long)concatDimSize));
            } else {
                typeBuilder.add(dimension);
            }
            ++dimensionIndex;
        }
        return typeBuilder.build();
    }

    @Override
    protected TensorFunction<Reference> lazyGetFunction() {
        if (!this.inputs.stream().map(IntermediateOperation::function).allMatch(Optional::isPresent)) {
            return null;
        }
        Concat result = ((IntermediateOperation)this.inputs.get(0)).function().get();
        for (int i = 1; i < this.inputs.size(); ++i) {
            TensorFunction<Reference> b = ((IntermediateOperation)this.inputs.get(i)).function().get();
            result = new Concat(result, b, this.concatDimensionName);
        }
        return result;
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        if (!this.inputs.stream().map(IntermediateOperation::type).allMatch(Optional::isPresent)) {
            return;
        }
        OrderedTensorType a = ((IntermediateOperation)this.inputs.get(0)).type().get();
        for (int i = 1; i < this.inputs.size(); ++i) {
            OrderedTensorType b = ((IntermediateOperation)this.inputs.get(i)).type().get();
            String bDim = b.dimensions().get(this.concatDimensionIndex).name();
            String aDim = a.dimensions().get(this.concatDimensionIndex).name();
            renamer.addConstraint(aDim, bDim, DimensionRenamer.Constraint.equal(false), this);
        }
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        this.concatDimensionName = renamer.dimensionNameOf(this.concatDimensionName).orElse(this.concatDimensionName);
    }

    @Override
    public OnnxConcat withInputs(List<IntermediateOperation> inputs) {
        return new OnnxConcat(this.modelName(), this.name(), inputs, this.attributeMap);
    }

    @Override
    public String operationName() {
        return "ConcatV2";
    }
}

