/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.utils;

import ai.vespa.modelintegration.utils.ModelPathHelper;
import ai.vespa.secret.Secret;
import ai.vespa.secret.Secrets;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.ModelReference;
import com.yahoo.config.UrlReference;
import com.yahoo.vespa.config.UrlDownloader;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Optional;

public class ModelPathHelperImpl
extends AbstractComponent
implements ModelPathHelper {
    public static final Duration MODEL_DOWNLOAD_TIMEOUT = Duration.ofMinutes(60L);
    private final Secrets secrets;
    private final ModelResolverFunction modelResolverFunction;
    private UrlDownloader urlDownloader;
    private ModelResolverFunction defaultModelResolverFunction = (urlReference, downloadOptions) -> {
        File file = this.urlDownloader.waitFor(urlReference, downloadOptions, MODEL_DOWNLOAD_TIMEOUT);
        return Paths.get(file.getAbsolutePath(), new String[0]);
    };

    @Inject
    public ModelPathHelperImpl(Secrets secrets) {
        this.secrets = secrets;
        this.urlDownloader = new UrlDownloader();
        this.modelResolverFunction = this.defaultModelResolverFunction;
    }

    ModelPathHelperImpl(Secrets secrets, ModelResolverFunction modelResolverFunction) {
        this.secrets = secrets;
        this.modelResolverFunction = modelResolverFunction;
    }

    public void deconstruct() {
        this.urlDownloader.shutdown();
        super.deconstruct();
    }

    @Override
    public Path getModelPathResolvingIfNecessary(ModelReference modelReference) {
        if (this.isModelDownloadRequired(modelReference)) {
            return this.resolveModelAndReturnPath(modelReference);
        }
        return modelReference.value();
    }

    private boolean isModelDownloadRequired(ModelReference modelReference) {
        return !modelReference.isResolved() && modelReference.url().isPresent();
    }

    private Path resolveModelAndReturnPath(ModelReference modelReference) {
        UrlReference modelUrl = (UrlReference)modelReference.url().orElseThrow();
        Optional secretRef = modelReference.secretRef();
        UrlDownloader.DownloadOptions downloadOptions = UrlDownloader.DownloadOptions.defaultOptions();
        if (secretRef.isPresent()) {
            Secret secret = this.secrets.get((String)secretRef.get());
            downloadOptions = UrlDownloader.DownloadOptions.ofAuthToken((String)secret.current());
        }
        return this.modelResolverFunction.apply(modelUrl, downloadOptions);
    }

    @FunctionalInterface
    static interface ModelResolverFunction {
        public Path apply(UrlReference var1, UrlDownloader.DownloadOptions var2);
    }
}

