/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.vespa.parser;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.vespa.parser.CharStream;
import ai.vespa.rankingexpression.importer.vespa.parser.ModelParserConstants;
import ai.vespa.rankingexpression.importer.vespa.parser.ModelParserTokenManager;
import ai.vespa.rankingexpression.importer.vespa.parser.ParseException;
import ai.vespa.rankingexpression.importer.vespa.parser.SimpleCharStream;
import ai.vespa.rankingexpression.importer.vespa.parser.Token;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.JsonFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ModelParser
implements ModelParserConstants {
    private ImportedModel model;
    public ModelParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[58];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ModelParser(String input, ImportedModel model) {
        this(new SimpleCharStream(input), model);
    }

    public ModelParser(SimpleCharStream input, ImportedModel model) {
        this(input);
        this.model = model;
    }

    public final void model() throws ParseException {
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(17);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        String name = this.identifier();
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(10);
        this.modelContent();
        this.jj_consume_token(11);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(0);
        if (!this.model.name().endsWith(name)) {
            throw new IllegalArgumentException("Unexpected model name '" + this.model.name() + "': Model '" + name + "' must be saved in a file named '" + name + ".model'");
        }
    }

    public final void modelContent() throws ParseException {
        block12: {
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 39: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        continue block11;
                    }
                    case 31: {
                        this.constants();
                        continue block11;
                    }
                    case 30: {
                        this.largeConstant();
                        continue block11;
                    }
                    case 6: {
                        this.function();
                        continue block11;
                    }
                    case 16: {
                        this.inputs();
                        continue block11;
                    }
                    case 15: 
                    case 17: 
                    case 18: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 39: {
                        this.input();
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void inputs() throws ParseException {
        this.jj_consume_token(16);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(10);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block14;
                }
            }
            this.input();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(11);
    }

    public final void input() throws ParseException {
        String name = this.identifier();
        this.jj_consume_token(12);
        TensorType type = this.tensorType("Input parameter '" + name + "'");
        this.model.input(name, type);
    }

    public final void function() throws ParseException {
        ArrayList<String> parameters = new ArrayList<String>();
        this.jj_consume_token(6);
        String name = this.identifier();
        this.jj_consume_token(46);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: {
                String parameter = this.identifier();
                parameters.add(parameter);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 14: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(14);
                    parameter = this.identifier();
                    parameters.add(parameter);
                }
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(47);
        this.lbrace();
        String expression = this.expression();
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(11);
        this.model.expression(name, expression);
    }

    public final void constants() throws ParseException {
        this.jj_consume_token(31);
        this.jj_consume_token(10);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block10;
                }
            }
            this.constant();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        continue block10;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(11);
    }

    public final String constantTensorErrorMessage(String constantTensorName) throws ParseException {
        return "For constant tensor '" + constantTensorName + "' in '" + String.valueOf(this.model) + "'";
    }

    public final void constant() throws ParseException {
        String name = null;
        TensorType type = TensorType.empty;
        Tensor value = null;
        String valuePath = null;
        name = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        if (this.jj_2_1(4)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: 
                case 15: {
                    type = this.valueType(name);
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: {
                    this.jj_consume_token(12);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                }
            }
            block25: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        break block25;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 38: 
                case 39: 
                case 40: 
                case 48: {
                    value = this.tensorValue(type);
                    break;
                }
                case 32: {
                    valuePath = this.fileItem();
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (value != null) {
                this.model.smallConstant(name, value);
            } else {
                try {
                    value = JsonFormat.decode((TensorType)type, (byte[])IOUtils.readFileBytes((File)this.model.relativeFile(valuePath, "constant '" + name + "'")));
                    this.model.largeConstant(name, value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not read constant '" + name + "'", e);
                }
            }
        } else {
            block17 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 12: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 12: {
                            this.constantValue(name);
                            break block17;
                        }
                        case 10: {
                            this.constantTensor(name);
                            break block17;
                        }
                    }
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void constantValue(String name) throws ParseException {
        this.jj_consume_token(12);
        Token value = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38 -> this.jj_consume_token(38);
            case 39 -> this.jj_consume_token(39);
            case 34 -> this.jj_consume_token(34);
            default -> {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        this.model.smallConstant(name, Tensor.from((String)value.image));
    }

    public final void constantTensor(String name) throws ParseException {
        String tensorString = "";
        TensorType type = null;
        this.jj_consume_token(10);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block14;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: 
                case 9: {
                    tensorString = this.tensorValuePrefixedByValue();
                    break;
                }
                case 7: {
                    type = this.tensorTypeWithPrefix(this.constantTensorErrorMessage(name));
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(11);
        this.model.smallConstant(name, type != null ? Tensor.from((TensorType)type, (String)tensorString) : Tensor.from((String)tensorString));
    }

    public final TensorType valueType(String name) throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7 -> this.tensorType("Type of " + name);
            case 15 -> {
                this.jj_consume_token(15);
                yield TensorType.empty;
            }
            default -> {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final TensorType tensorType(String errorMessage) throws ParseException {
        TensorType tensorType;
        this.jj_consume_token(7);
        String tensorTypeString = this.token.image;
        try {
            tensorType = TensorType.fromSpec((String)tensorTypeString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorMessage + ": Illegal tensor type spec: " + e.getMessage());
        }
        return tensorType;
    }

    public final Tensor tensorValue(TensorType type) throws ParseException {
        Tensor.Builder builder = Tensor.Builder.of((TensorType)type);
        Number doubleValue = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                this.mappedTensorValue(builder);
                break;
            }
            case 48: {
                this.indexedTensorValues(builder);
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                doubleValue = this.number();
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (doubleValue != null) {
            if (type.rank() > 0) {
                throw new IllegalArgumentException("A tensor of type " + String.valueOf(type) + " cannot be a number");
            }
            builder.cell(doubleValue.doubleValue(), new long[0]);
        }
        return builder.build();
    }

    public final void mappedTensorValue(Tensor.Builder builder) throws ParseException {
        this.jj_consume_token(10);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block9;
                }
            }
            this.mappedTensorBlock(builder);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(14);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(5);
            }
            this.mappedTensorBlock(builder);
        }
        this.jj_consume_token(11);
    }

    public final void mappedTensorBlock(Tensor.Builder builder) throws ParseException {
        TensorAddress mappedAddress = this.tensorAddress(builder.type());
        this.jj_consume_token(12);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: 
            case 39: 
            case 40: {
                this.mappedTensorCellValue(mappedAddress, builder);
                break;
            }
            case 48: {
                this.indexedTensorBlockValues(mappedAddress, builder);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void indexedTensorBlockValues(TensorAddress mappedAddress, Tensor.Builder builder) throws ParseException {
        ArrayList<Double> values = new ArrayList<Double>();
        this.arrayTensorValues(values);
        MixedTensor.BoundBuilder boundBuilder = (MixedTensor.BoundBuilder)builder;
        double[] arrayValues = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            arrayValues[i] = (Double)values.get(i);
        }
        boundBuilder.block(mappedAddress, arrayValues);
    }

    public final void indexedTensorValues(Tensor.Builder builder) throws ParseException {
        ArrayList<Double> values = new ArrayList<Double>();
        this.arrayTensorValues(values);
        IndexedTensor.BoundBuilder boundBuilder = (IndexedTensor.BoundBuilder)builder;
        double[] arrayValues = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            arrayValues[i] = (Double)values.get(i);
        }
        boundBuilder.fill(arrayValues);
    }

    public final void arrayTensorValues(List<Double> values) throws ParseException {
        block21: {
            block20: {
                this.jj_consume_token(48);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 38: 
                        case 39: 
                        case 40: 
                        case 48: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block20;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 38: 
                        case 39: 
                        case 40: {
                            this.indexedTensorValue(values);
                            continue block17;
                        }
                        case 48: {
                            this.arrayTensorValues(values);
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: {
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(14);
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[38] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(5);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 38: 
                    case 39: 
                    case 40: {
                        this.indexedTensorValue(values);
                        continue block18;
                    }
                    case 48: {
                        this.arrayTensorValues(values);
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[39] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(49);
    }

    public final void indexedTensorValue(List<Double> values) throws ParseException {
        Number value = this.number();
        values.add(value.doubleValue());
    }

    public final void mappedTensorCellValue(TensorAddress address, Tensor.Builder builder) throws ParseException {
        double value = this.tensorCellValue();
        builder.cell(address, value);
    }

    public final TensorAddress tensorAddress(TensorType type) throws ParseException {
        TensorAddress.PartialBuilder builder = new TensorAddress.PartialBuilder(type);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                String label = this.tensorAddressLabel();
                builder.add(label);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 39: {
                            break;
                        }
                        default: {
                            this.jj_la1[40] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.tensorAddressElement((TensorAddress.Builder)builder);
                }
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 14: {
                            break;
                        }
                        default: {
                            this.jj_la1[41] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(14);
                    this.tensorAddressElement((TensorAddress.Builder)builder);
                }
                this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return builder.build();
    }

    public final void tensorAddressElement(TensorAddress.Builder builder) throws ParseException {
        String dimension = this.identifier();
        this.jj_consume_token(12);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(5);
        }
        String label = this.tensorAddressLabel();
        builder.add(dimension, label);
    }

    public final String tensorAddressLabel() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15, 16, 17, 18, 30, 31, 32, 33, 34, 39 -> this.identifier();
            case 35, 36 -> this.quotedString();
            default -> {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final double tensorCellValue() throws ParseException {
        Number value = this.number();
        return value.doubleValue();
    }

    public final String tensorValuePrefixedByValue() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8 -> {
                this.jj_consume_token(8);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1);
            }
            case 9 -> {
                this.jj_consume_token(9);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
            }
            default -> {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final TensorType tensorTypeWithPrefix(String errorMessage) throws ParseException {
        TensorType tensorType;
        this.jj_consume_token(7);
        String tensorTypeString = this.token.image;
        try {
            tensorType = TensorType.fromSpec((String)tensorTypeString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorMessage + ": Illegal tensor type spec: " + e.getMessage());
        }
        return tensorType;
    }

    public final void largeConstant() throws ParseException {
        this.jj_consume_token(30);
        String name = this.identifier();
        this.lbrace();
        Tensor value = this.largeConstantBody(name);
        this.jj_consume_token(11);
        this.model.largeConstant(name, value);
    }

    public final Tensor largeConstantBody(String name) throws ParseException {
        String path = null;
        TensorType type = null;
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: {
                    this.jj_consume_token(32);
                    this.jj_consume_token(12);
                    path = this.filePath();
                    break;
                }
                case 18: {
                    this.jj_consume_token(18);
                    this.jj_consume_token(12);
                    type = this.tensorType("Constant '" + name + "'");
                    break;
                }
                case 5: {
                    this.jj_consume_token(5);
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 18: 
                case 32: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[47] = this.jj_gen;
        try {
            return JsonFormat.decode((TensorType)type, (byte[])IOUtils.readFileBytes((File)this.model.relativeFile(path, "constant '" + name + "'")));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not read constant '" + name + "'", e);
        }
    }

    public final String filePath() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String uriPath() throws ParseException {
        this.jj_consume_token(44);
        return this.token.image;
    }

    public final String expression() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 19 -> {
                this.jj_consume_token(19);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1);
            }
            case 20 -> {
                this.jj_consume_token(20);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
            }
            default -> {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final String identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final Number number() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38 -> this.floatValue();
            case 39, 40 -> this.longValue();
            default -> {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final long longValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 39: {
                this.jj_consume_token(39);
                return Long.parseLong(this.token.image);
            }
            case 40: {
                this.jj_consume_token(40);
                return Long.parseLong(this.token.image.substring(0, this.token.image.length() - 1));
            }
        }
        this.jj_la1[52] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double floatValue() throws ParseException {
        this.jj_consume_token(38);
        return Double.valueOf(this.token.image);
    }

    public final void lbrace() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(10);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
    }

    public final String fileItem() throws ParseException {
        this.jj_consume_token(32);
        this.jj_consume_token(12);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String path = Path.fromString((String)this.token.image).getRelative();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                    break block8;
                }
            }
            this.jj_consume_token(5);
        }
        return path;
    }

    public final String quotedString() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.substring(1, this.token.image.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_3R_33() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_43() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_50() {
        Token xsp;
        if (this.jj_scan_token(48)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_54());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_55());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_55() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_64()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_71() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_60() {
        return this.jj_3R_70();
    }

    private boolean jj_3R_69() {
        return this.jj_3R_75();
    }

    private boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_62()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_61() {
        return this.jj_3R_71();
    }

    private boolean jj_3R_63() {
        return this.jj_3R_71();
    }

    private boolean jj_3R_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_40()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_79() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(31)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(15)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(32)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(34)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(16)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(39)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(17)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(18)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(33)) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_68()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_39() {
        return this.jj_3R_44();
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_67() {
        return this.jj_3R_72();
    }

    private boolean jj_3R_68() {
        Token xsp;
        if (this.jj_scan_token(10)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_73());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_74());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_78() {
        if (this.jj_3R_79()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_73() {
        return this.jj_3R_78();
    }

    private boolean jj_3R_34() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_52()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_51() {
        return this.jj_3R_56();
    }

    private boolean jj_3R_72() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_76()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_77()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_62() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_66()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_64() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_76() {
        return this.jj_3R_79();
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_75() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_56() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_42()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_43()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_41() {
        return this.jj_3R_45();
    }

    private boolean jj_3R_52() {
        return this.jj_3R_57();
    }

    private boolean jj_3R_35() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_38() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(42)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(41)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(34)) {
                    return true;
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_45() {
        Token xsp;
        if (this.jj_scan_token(10)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_48());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_49());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_77() {
        return this.jj_3R_80();
    }

    private boolean jj_3R_74() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_3R_78();
    }

    private boolean jj_3R_48() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_49() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        return this.jj_3R_53();
    }

    private boolean jj_3R_80() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(36)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_53() {
        Token xsp;
        if (this.jj_3R_58()) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_60()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_59() {
        return this.jj_3R_69();
    }

    private boolean jj_3R_42() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_70() {
        return this.jj_3R_50();
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_35()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_46() {
        return this.jj_3R_50();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 32, 32, 32, -1073250208, -1073250208, 32, 32, -1073250304, 32, 16384, -1073250304, 32, 32, -1073250304, 32, 4096, 32896, 4096, 32, 1024, 5120, 5120, 0, 32, 896, 896, 32, 32896, 1024, -1073249280, 16384, 32, 32, 0, 0, 0, 16384, 32, 0, -1073250304, 16384, -1073249280, 32, -1073250304, 768, 262176, 262176, 0, 0x180000, -1073250304, 0, 0, 32, 32, 0, 32, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 135, 135, 0, 0, 135, 0, 0, 135, 0, 0, 135, 0, 0, 0, 0, 0, 65985, 0, 0, 196, 0, 0, 0, 0, 0, 65984, 159, 0, 0, 0, 65984, 65984, 65984, 0, 0, 65984, 135, 0, 159, 0, 159, 0, 1, 1, 1540, 0, 135, 448, 384, 0, 0, 1540, 0, 24};
    }

    public ModelParser(CharStream stream) {
        int i;
        this.token_source = new ModelParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 58; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 58; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ModelParser(ModelParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 58; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ModelParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 58; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private int jj_ntk_f() {
        int ret;
        this.jj_nt = this.token.next;
        Token nt = this.jj_nt;
        if (nt == null) {
            this.token.next = this.token_source.getNextToken();
            ret = this.jj_ntk = this.token.next.kind;
        } else {
            ret = this.jj_ntk = nt.kind;
        }
        return ret;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[50];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 58; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 50; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 1; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_scanpos = p.first;
                    this.jj_lastpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ModelParser.jj_la1_init_0();
        ModelParser.jj_la1_init_1();
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

