/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class LlmLocalClientConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "b1e30c070dcf57a27447861eae37548d";
    public static final String CONFIG_DEF_NAME = "llm-local-client";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.llm.clients";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.llm.clients", "model model", "parallelRequests int default=1", "maxQueueSize int default=100", "maxQueueWait int default=10000", "maxEnqueueWait int default=10000", "useGpu bool default=true", "gpuLayers int default=1000000", "threads int default=-1", "contextSize int default=4096", "maxTokens int default=512", "maxPromptTokens int default = 0", "contextOverflowPolicy enum {NONE, DISCARD, FAIL} default=NONE", "seed int default = -1"};
    private final ModelNode model;
    private final IntegerNode parallelRequests;
    private final IntegerNode maxQueueSize;
    private final IntegerNode maxQueueWait;
    private final IntegerNode maxEnqueueWait;
    private final BooleanNode useGpu;
    private final IntegerNode gpuLayers;
    private final IntegerNode threads;
    private final IntegerNode contextSize;
    private final IntegerNode maxTokens;
    private final IntegerNode maxPromptTokens;
    private final ContextOverflowPolicy contextOverflowPolicy;
    private final IntegerNode seed;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LlmLocalClientConfig(Builder builder) {
        this(builder, true);
    }

    private LlmLocalClientConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for llm-local-client must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.model = builder.model == null ? new ModelNode() : new ModelNode(builder.model);
        this.parallelRequests = builder.parallelRequests == null ? new IntegerNode(1) : new IntegerNode(builder.parallelRequests.intValue());
        this.maxQueueSize = builder.maxQueueSize == null ? new IntegerNode(100) : new IntegerNode(builder.maxQueueSize.intValue());
        this.maxQueueWait = builder.maxQueueWait == null ? new IntegerNode(10000) : new IntegerNode(builder.maxQueueWait.intValue());
        this.maxEnqueueWait = builder.maxEnqueueWait == null ? new IntegerNode(10000) : new IntegerNode(builder.maxEnqueueWait.intValue());
        this.useGpu = builder.useGpu == null ? new BooleanNode(true) : new BooleanNode(builder.useGpu.booleanValue());
        this.gpuLayers = builder.gpuLayers == null ? new IntegerNode(1000000) : new IntegerNode(builder.gpuLayers.intValue());
        this.threads = builder.threads == null ? new IntegerNode(-1) : new IntegerNode(builder.threads.intValue());
        this.contextSize = builder.contextSize == null ? new IntegerNode(4096) : new IntegerNode(builder.contextSize.intValue());
        this.maxTokens = builder.maxTokens == null ? new IntegerNode(512) : new IntegerNode(builder.maxTokens.intValue());
        this.maxPromptTokens = builder.maxPromptTokens == null ? new IntegerNode(0) : new IntegerNode(builder.maxPromptTokens.intValue());
        this.contextOverflowPolicy = builder.contextOverflowPolicy == null ? new ContextOverflowPolicy(ContextOverflowPolicy.NONE) : new ContextOverflowPolicy(builder.contextOverflowPolicy);
        this.seed = builder.seed == null ? new IntegerNode(-1) : new IntegerNode(builder.seed.intValue());
    }

    public Path model() {
        return (Path)this.model.value();
    }

    public int parallelRequests() {
        return this.parallelRequests.value();
    }

    public int maxQueueSize() {
        return this.maxQueueSize.value();
    }

    public int maxQueueWait() {
        return this.maxQueueWait.value();
    }

    public int maxEnqueueWait() {
        return this.maxEnqueueWait.value();
    }

    public boolean useGpu() {
        return this.useGpu.value();
    }

    public int gpuLayers() {
        return this.gpuLayers.value();
    }

    public int threads() {
        return this.threads.value();
    }

    public int contextSize() {
        return this.contextSize.value();
    }

    public int maxTokens() {
        return this.maxTokens.value();
    }

    public int maxPromptTokens() {
        return this.maxPromptTokens.value();
    }

    public ContextOverflowPolicy.Enum contextOverflowPolicy() {
        return (ContextOverflowPolicy.Enum)((Object)this.contextOverflowPolicy.value());
    }

    public int seed() {
        return this.seed.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LlmLocalClientConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("model"));
        private ModelReference model = null;
        private Integer parallelRequests = null;
        private Integer maxQueueSize = null;
        private Integer maxQueueWait = null;
        private Integer maxEnqueueWait = null;
        private Boolean useGpu = null;
        private Integer gpuLayers = null;
        private Integer threads = null;
        private Integer contextSize = null;
        private Integer maxTokens = null;
        private Integer maxPromptTokens = null;
        private ContextOverflowPolicy.Enum contextOverflowPolicy = null;
        private Integer seed = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LlmLocalClientConfig config) {
            this.model(config.model.getModelReference());
            this.parallelRequests(config.parallelRequests());
            this.maxQueueSize(config.maxQueueSize());
            this.maxQueueWait(config.maxQueueWait());
            this.maxEnqueueWait(config.maxEnqueueWait());
            this.useGpu(config.useGpu());
            this.gpuLayers(config.gpuLayers());
            this.threads(config.threads());
            this.contextSize(config.contextSize());
            this.maxTokens(config.maxTokens());
            this.maxPromptTokens(config.maxPromptTokens());
            this.contextOverflowPolicy(config.contextOverflowPolicy());
            this.seed(config.seed());
        }

        private Builder override(Builder __superior) {
            if (__superior.model != null) {
                this.model(__superior.model);
            }
            if (__superior.parallelRequests != null) {
                this.parallelRequests(__superior.parallelRequests);
            }
            if (__superior.maxQueueSize != null) {
                this.maxQueueSize(__superior.maxQueueSize);
            }
            if (__superior.maxQueueWait != null) {
                this.maxQueueWait(__superior.maxQueueWait);
            }
            if (__superior.maxEnqueueWait != null) {
                this.maxEnqueueWait(__superior.maxEnqueueWait);
            }
            if (__superior.useGpu != null) {
                this.useGpu(__superior.useGpu);
            }
            if (__superior.gpuLayers != null) {
                this.gpuLayers(__superior.gpuLayers);
            }
            if (__superior.threads != null) {
                this.threads(__superior.threads);
            }
            if (__superior.contextSize != null) {
                this.contextSize(__superior.contextSize);
            }
            if (__superior.maxTokens != null) {
                this.maxTokens(__superior.maxTokens);
            }
            if (__superior.maxPromptTokens != null) {
                this.maxPromptTokens(__superior.maxPromptTokens);
            }
            if (__superior.contextOverflowPolicy != null) {
                this.contextOverflowPolicy(__superior.contextOverflowPolicy);
            }
            if (__superior.seed != null) {
                this.seed(__superior.seed);
            }
            return this;
        }

        public Builder model(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.model = __value;
            this.__uninitialized.remove("model");
            return this;
        }

        public Builder parallelRequests(int __value) {
            this.parallelRequests = __value;
            return this;
        }

        private Builder parallelRequests(String __value) {
            return this.parallelRequests(Integer.valueOf(__value));
        }

        public Builder maxQueueSize(int __value) {
            this.maxQueueSize = __value;
            return this;
        }

        private Builder maxQueueSize(String __value) {
            return this.maxQueueSize(Integer.valueOf(__value));
        }

        public Builder maxQueueWait(int __value) {
            this.maxQueueWait = __value;
            return this;
        }

        private Builder maxQueueWait(String __value) {
            return this.maxQueueWait(Integer.valueOf(__value));
        }

        public Builder maxEnqueueWait(int __value) {
            this.maxEnqueueWait = __value;
            return this;
        }

        private Builder maxEnqueueWait(String __value) {
            return this.maxEnqueueWait(Integer.valueOf(__value));
        }

        public Builder useGpu(boolean __value) {
            this.useGpu = __value;
            return this;
        }

        private Builder useGpu(String __value) {
            return this.useGpu(Boolean.valueOf(__value));
        }

        public Builder gpuLayers(int __value) {
            this.gpuLayers = __value;
            return this;
        }

        private Builder gpuLayers(String __value) {
            return this.gpuLayers(Integer.valueOf(__value));
        }

        public Builder threads(int __value) {
            this.threads = __value;
            return this;
        }

        private Builder threads(String __value) {
            return this.threads(Integer.valueOf(__value));
        }

        public Builder contextSize(int __value) {
            this.contextSize = __value;
            return this;
        }

        private Builder contextSize(String __value) {
            return this.contextSize(Integer.valueOf(__value));
        }

        public Builder maxTokens(int __value) {
            this.maxTokens = __value;
            return this;
        }

        private Builder maxTokens(String __value) {
            return this.maxTokens(Integer.valueOf(__value));
        }

        public Builder maxPromptTokens(int __value) {
            this.maxPromptTokens = __value;
            return this;
        }

        private Builder maxPromptTokens(String __value) {
            return this.maxPromptTokens(Integer.valueOf(__value));
        }

        public Builder contextOverflowPolicy(ContextOverflowPolicy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.contextOverflowPolicy = __value;
            return this;
        }

        private Builder contextOverflowPolicy(String __value) {
            return this.contextOverflowPolicy(ContextOverflowPolicy.Enum.valueOf(__value));
        }

        public Builder seed(int __value) {
            this.seed = __value;
            return this;
        }

        private Builder seed(String __value) {
            return this.seed(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LlmLocalClientConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LlmLocalClientConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LlmLocalClientConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LlmLocalClientConfig build() {
            return new LlmLocalClientConfig(this);
        }
    }

    public static final class ContextOverflowPolicy
    extends EnumNode<Enum> {
        public static final Enum NONE = Enum.NONE;
        public static final Enum DISCARD = Enum.DISCARD;
        public static final Enum FAIL = Enum.FAIL;

        public ContextOverflowPolicy() {
            this.value = null;
        }

        public ContextOverflowPolicy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            NONE,
            DISCARD,
            FAIL;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

