/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics;

import ai.vespa.metrics.Unit;
import ai.vespa.metrics.VespaMetrics;

public enum HostedNodeAdminMetrics implements VespaMetrics
{
    COREDUMPS_PROCESSED("coredumps.processed", Unit.OPERATION, "Number of coredumps processed"),
    CPU_UTIL("cpu.util", Unit.PERCENTAGE, "CPU utilisation"),
    CPU_SYS_UTIL("cpu.sys.util", Unit.PERCENTAGE, "System CPU utilisation"),
    CPU_THROTTLED_TIME("cpu.throttled_time.rate", Unit.PERCENTAGE, "Part of the time CPU is exhausted (CPU throttling enforced)"),
    CPU_THROTTLED_CPU_TIME("cpu.throttled_cpu_time.rate", Unit.PERCENTAGE, "Part of the time CPU is exhausted (CPU throttling enforced)"),
    CPU_VCPUS("cpu.vcpus", Unit.ITEM, "Number of virtual CPU threads allocation to the node"),
    DISK_LIMIT("disk.limit", Unit.BYTE, "Amount of disk space available on the node"),
    DISK_USED("disk.used", Unit.BYTE, "Amount of disk space used by the node"),
    DISK_UTIL("disk.util", Unit.PERCENTAGE, "Disk space utilisation"),
    MEM_LIMIT("mem.limit", Unit.BYTE, "Amount of memory available on the node"),
    MEM_USED("mem.used", Unit.BYTE, "Amount of memory used by the node"),
    MEM_UTIL("mem.util", Unit.PERCENTAGE, "Memory utilisation"),
    MEM_TOTAL_USED("mem_total.used", Unit.BYTE, "Total amount of memory used by the node, including OS buffer caches"),
    MEM_TOTAL_UTIL("mem_total.util", Unit.PERCENTAGE, "Total memory utilisation"),
    MEM_SOCK("mem.sock", Unit.BYTE, "Amount of memory used in network transmission buffers"),
    MEM_SLAB_RECLAIMABLE("mem.slab_reclaimable", Unit.BYTE, "Amount of 'slab' that might be reclaimed"),
    MEM_SLAB("mem.slab", Unit.BYTE, "Amount of memory used for storing in-kernel data structures"),
    MEM_ANON("mem.anon", Unit.BYTE, "Amount of memory used in anonymous mappings"),
    GPU_UTIL("gpu.util", Unit.PERCENTAGE, "GPU utilisation"),
    GPU_MEM_USED("gpu.memory.used", Unit.BYTE, "GPU memory used"),
    GPU_MEM_TOTAL("gpu.memory.total", Unit.BYTE, "GPU memory available"),
    NET_IN_BYTES("net.in.bytes", Unit.BYTE, "Network bytes received (rxBytes) (COUNT metric)"),
    NET_IN_ERROR("net.in.errors", Unit.FAILURE, "Network receive errors (rxErrors)"),
    NET_IN_DROPPED("net.in.dropped", Unit.PACKET, "Inbound network packets dropped (rxDropped)"),
    NET_OUT_BYTES("net.out.bytes", Unit.BYTE, "Network bytes sent (txBytes) (COUNT metric)"),
    NET_OUT_ERROR("net.out.errors", Unit.FAILURE, "Network send errors (txErrors)"),
    NET_OUT_DROPPED("net.out.dropped", Unit.PACKET, "Outbound network packets dropped (txDropped)"),
    BANDWIDTH_LIMIT("bandwidth.limit", Unit.BYTE_PER_SECOND, "Available network bandwidth");

    private final String name;
    private final Unit unit;
    private final String description;

    private HostedNodeAdminMetrics(String name, Unit unit, String description) {
        this.name = name;
        this.unit = unit;
        this.description = description;
    }

    @Override
    public String baseName() {
        return this.name;
    }

    @Override
    public Unit unit() {
        return this.unit;
    }

    @Override
    public String description() {
        return this.description;
    }
}

