/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.set;

import ai.vespa.metrics.ClusterControllerMetrics;
import ai.vespa.metrics.ContainerMetrics;
import ai.vespa.metrics.DistributorMetrics;
import ai.vespa.metrics.LogdMetrics;
import ai.vespa.metrics.NodeAdminMetrics;
import ai.vespa.metrics.RoutingLayerMetrics;
import ai.vespa.metrics.SearchNodeMetrics;
import ai.vespa.metrics.SentinelMetrics;
import ai.vespa.metrics.SlobrokMetrics;
import ai.vespa.metrics.StorageMetrics;
import ai.vespa.metrics.Suffix;
import ai.vespa.metrics.VespaMetrics;
import ai.vespa.metrics.set.BasicMetricSets;
import ai.vespa.metrics.set.DefaultVespaMetrics;
import ai.vespa.metrics.set.Metric;
import ai.vespa.metrics.set.MetricSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class VespaMetricSet {
    public static final MetricSet vespaMetricSet = VespaMetricSet.createMetricSet();

    private static MetricSet createMetricSet() {
        return new MetricSet("vespa", VespaMetricSet.getVespaMetrics(), List.of(DefaultVespaMetrics.defaultVespaMetricSet, BasicMetricSets.containerHttpStatusMetrics()));
    }

    private static Set<Metric> getVespaMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        metrics.addAll(VespaMetricSet.getSearchNodeMetrics());
        metrics.addAll(VespaMetricSet.getStorageMetrics());
        metrics.addAll(VespaMetricSet.getDistributorMetrics());
        metrics.addAll(VespaMetricSet.getDocprocMetrics());
        metrics.addAll(VespaMetricSet.getClusterControllerMetrics());
        metrics.addAll(VespaMetricSet.getSearchChainMetrics());
        metrics.addAll(VespaMetricSet.getContainerMetrics());
        metrics.addAll(VespaMetricSet.getSentinelMetrics());
        metrics.addAll(VespaMetricSet.getOtherMetrics());
        return Collections.unmodifiableSet(metrics);
    }

    private static Set<Metric> getSentinelMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        VespaMetricSet.addMetric(metrics, SentinelMetrics.SENTINEL_RESTARTS.count());
        VespaMetricSet.addMetric(metrics, SentinelMetrics.SENTINEL_TOTAL_RESTARTS, EnumSet.of(Suffix.max, Suffix.sum, Suffix.last));
        VespaMetricSet.addMetric(metrics, SentinelMetrics.SENTINEL_UPTIME.last());
        VespaMetricSet.addMetric(metrics, SentinelMetrics.SENTINEL_RUNNING, EnumSet.of(Suffix.count, Suffix.last));
        return metrics;
    }

    private static Set<Metric> getOtherMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        VespaMetricSet.addMetric(metrics, SlobrokMetrics.SLOBROK_HEARTBEATS_FAILED.count());
        VespaMetricSet.addMetric(metrics, SlobrokMetrics.SLOBROK_MISSING_CONSENSUS.count());
        VespaMetricSet.addMetric(metrics, LogdMetrics.LOGD_PROCESSED_LINES.count());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_TLS_CERTIFICATE_VERIFICATION_FAILURES.baseName());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_PEER_AUTHORIZATION_FAILURES.baseName());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_SERVER_TLS_CONNECTIONS_ESTABLISHED.baseName());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_CLIENT_TLS_CONNECTIONS_ESTABLISHED.baseName());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_SERVER_UNENCRYPTED_CONNECTIONS_ESTABLISHED.baseName());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JRT_TRANSPORT_CLIENT_UNENCRYPTED_CONNECTIONS_ESTABLISHED.baseName());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_TLS_HANDSHAKES_FAILED.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_PEER_AUTHORIZATION_FAILURES.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_CLIENT_TLS_CONNECTIONS_ESTABLISHED.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_SERVER_TLS_CONNECTIONS_ESTABLISHED.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_CLIENT_INSECURE_CONNECTIONS_ESTABLISHED.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_SERVER_INSECURE_CONNECTIONS_ESTABLISHED.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_TLS_CONNECTIONS_BROKEN.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_FAILED_TLS_CONFIG_RELOADS.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_RPC_CAPABILITY_CHECKS_FAILED.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_NETWORK_STATUS_CAPABILITY_CHECKS_FAILED.count());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_SERVER_FNET_NUM_CONNECTIONS.count());
        VespaMetricSet.addMetric(metrics, NodeAdminMetrics.ENDPOINT_CERTIFICATE_EXPIRY_SECONDS.baseName());
        VespaMetricSet.addMetric(metrics, NodeAdminMetrics.NODE_CERTIFICATE_EXPIRY_SECONDS.baseName());
        VespaMetricSet.addMetric(metrics, RoutingLayerMetrics.WORKER_CONNECTIONS.max());
        return metrics;
    }

    private static Set<Metric> getContainerMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTP_STATUS_1XX.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTP_STATUS_2XX.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTP_STATUS_3XX.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTP_STATUS_4XX.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTP_STATUS_5XX.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.APPLICATION_GENERATION.baseName());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HANDLED_REQUESTS.count());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HANDLED_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_NUM_OPEN_CONNECTIONS, EnumSet.of(Suffix.max, Suffix.last, Suffix.average));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_NUM_CONNECTIONS, EnumSet.of(Suffix.max, Suffix.last, Suffix.average));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_BYTES_RECEIVED, EnumSet.of(Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_BYTES_SENT, EnumSet.of(Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_UNHANDLED_EXCEPTIONS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_WORK_QUEUE_CAPACITY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_WORK_QUEUE_SIZE, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_REJECTED_TASKS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_SIZE, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_MAX_ALLOWED_SIZE, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_THREAD_POOL_ACTIVE_THREADS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_THREADPOOL_MAX_THREADS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_THREADPOOL_MIN_THREADS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_THREADPOOL_RESERVED_THREADS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_THREADPOOL_BUSY_THREADS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_THREADPOOL_TOTAL_THREADS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JETTY_THREADPOOL_QUEUE_SIZE, EnumSet.of(Suffix.sum, Suffix.count, Suffix.last, Suffix.min, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_PENDING, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NUM_OPERATIONS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NUM_UPDATES.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NUM_REMOVES.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NUM_PUTS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_SUCCEEDED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_FAILED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_PARSE_ERROR.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_CONDITION_NOT_MET.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_NOT_FOUND.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_FAILED_UNKNOWN.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_FAILED_INSUFFICIENT_STORAGE.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HTTPAPI_FAILED_TIMEOUT.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_HEAP_TOTAL.average());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_HEAP_FREE.average());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_HEAP_USED, EnumSet.of(Suffix.average, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_DIRECT_TOTAL.average());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_DIRECT_FREE.average());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_DIRECT_USED, EnumSet.of(Suffix.average, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_DIRECT_COUNT.max());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_NATIVE_TOTAL.average());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_NATIVE_FREE.average());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.MEM_NATIVE_USED.average());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_MEMORY_MAPPINGS.max());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_OPEN_FILE_DESCRIPTORS.max());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_GC_COUNT, EnumSet.of(Suffix.average, Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_GC_MS, EnumSet.of(Suffix.average, Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_DEACTIVATED_CONTAINERS_TOTAL, EnumSet.of(Suffix.sum, Suffix.last));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_DEACTIVATED_CONTAINERS_WITH_RETAINED_REFS.last());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_SINGLETON_IS_ACTIVE, EnumSet.of(Suffix.min, Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_SINGLETON_ACTIVATION_COUNT.last());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_SINGLETON_ACTIVATION_FAILURE_COUNT.last());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_SINGLETON_ACTIVATION_MILLIS.last());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_SINGLETON_DEACTIVATION_COUNT.last());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_SINGLETON_DEACTIVATION_FAILURE_COUNT.last());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_SINGLETON_DEACTIVATION_MILLIS.last());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ATHENZ_TENANT_CERT_EXPIRY_SECONDS, EnumSet.of(Suffix.min, Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.CONTAINER_IAM_ROLE_EXPIRY_SECONDS.baseName());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUEST_PREMATURELY_CLOSED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUEST_REQUESTS_PER_CONNECTION, EnumSet.of(Suffix.sum, Suffix.count, Suffix.min, Suffix.max, Suffix.average));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUEST_URI_LENGTH, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUEST_CONTENT_SIZE, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_REQUESTS, EnumSet.of(Suffix.rate, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_MISSING_CLIENT_CERT.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_EXPIRED_CLIENT_CERT.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_INVALID_CLIENT_CERT.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_INCOMPATIBLE_PROTOCOLS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_INCOMPATIBLE_CHIFERS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_CONNECTION_CLOSED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_SSL_HANDSHAKE_FAILURE_UNKNOWN.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_FILTER_RULE_BLOCKED_REQUESTS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_FILTER_RULE_ALLOWED_REQUESTS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_FILTERING_REQUEST_HANDLED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_FILTERING_REQUEST_UNHANDLED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_FILTERING_RESPONSE_HANDLED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_FILTERING_RESPONSE_UNHANDLED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_HTTP_HANDLER_UNHANDLED_EXCEPTIONS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_APPLICATION_FAILED_COMPONENT_GRAPHS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_APPLICATION_COMPONENT_GRAPH_CREATION_TIME_MILLIS.last());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_APPLICATION_COMPONENT_GRAPH_RECONFIGURATIONS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_JVM.last());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.FEED_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.FEED_HTTP_REQUESTS, EnumSet.of(Suffix.count, Suffix.rate));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.EMBEDDER_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.EMBEDDER_SEQUENCE_LENGTH, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_REJECTED_REQUESTS, EnumSet.of(Suffix.rate, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_THREAD_POOL_SIZE, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.SERVER_ACTIVE_THREADS, EnumSet.of(Suffix.min, Suffix.max, Suffix.sum, Suffix.count, Suffix.last));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_TLS_CAPABILITY_CHECKS_SUCCEEDED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_TLS_CAPABILITY_CHECKS_FAILED.rate());
        return metrics;
    }

    private static Set<Metric> getClusterControllerMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.DOWN_COUNT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.INITIALIZING_COUNT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.MAINTENANCE_COUNT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RETIRED_COUNT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.STOPPING_COUNT.last());
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.UP_COUNT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.NODES_NOT_CONVERGED.max());
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.CLUSTER_STATE_CHANGE_COUNT.baseName());
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.CLUSTER_BUCKETS_OUT_OF_SYNC_RATIO.max());
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.BUSY_TICK_TIME_MS, EnumSet.of(Suffix.last, Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.IDLE_TICK_TIME_MS, EnumSet.of(Suffix.last, Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.WORK_MS, EnumSet.of(Suffix.last, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.IS_MASTER, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.REMOTE_TASK_QUEUE_SIZE.last());
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.NODE_EVENT_COUNT.baseName());
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_NODES_ABOVE_LIMIT, EnumSet.of(Suffix.last, Suffix.max));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_MAX_MEMORY_UTILIZATION, EnumSet.of(Suffix.last, Suffix.max));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_MAX_DISK_UTILIZATION, EnumSet.of(Suffix.last, Suffix.max));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_MEMORY_LIMIT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.RESOURCE_USAGE_DISK_LIMIT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, ClusterControllerMetrics.REINDEXING_PROGRESS, EnumSet.of(Suffix.max, Suffix.last));
        return metrics;
    }

    private static Set<Metric> getDocprocMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        metrics.add(new Metric("documents_processed.rate"));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCPROC_PROC_TIME, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCPROC_DOCUMENTS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.min));
        return metrics;
    }

    private static Set<Metric> getSearchChainMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        VespaMetricSet.addMetric(metrics, ContainerMetrics.PEAK_QPS.max());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.SEARCH_CONNECTIONS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERIES.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_CONTAINER_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_TIMEOUT, EnumSet.of(Suffix.sum, new Suffix[]{Suffix.count, Suffix.max, Suffix.min, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile}));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.FAILED_QUERIES.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.DEGRADED_QUERIES.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.HITS_PER_QUERY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.SEARCH_CONNECTIONS, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_HIT_OFFSET, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCUMENTS_COVERED.count());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCUMENTS_TOTAL.count());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.DOCUMENTS_TARGET_TOTAL.count());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.JDISC_RENDER_LATENCY, EnumSet.of(Suffix.min, new Suffix[]{Suffix.max, Suffix.count, Suffix.sum, Suffix.last, Suffix.average}));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.QUERY_ITEM_COUNT, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.TOTAL_HITS_PER_QUERY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.EMPTY_RESULTS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.REQUESTS_OVER_QUOTA, EnumSet.of(Suffix.rate, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.RELEVANCE_AT_1, EnumSet.of(Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.RELEVANCE_AT_3, EnumSet.of(Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.RELEVANCE_AT_10, EnumSet.of(Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_TIMEOUT.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_BACKENDS_OOS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_PLUGIN_FAILURE.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_BACKEND_COMMUNICATION_ERROR.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_EMPTY_DOCUMENT_SUMMARIES.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_INVALID_QUERY_PARAMETER.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_INTERNAL_SERVER_ERROR.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_MISCONFIGURED_SERVER.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_INVALID_QUERY_TRANSFORMATION.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_RESULTS_WITH_ERRORS.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_UNSPECIFIED.rate());
        VespaMetricSet.addMetric(metrics, ContainerMetrics.ERROR_UNHANDLED_EXCEPTION.rate());
        return metrics;
    }

    private static Set<Metric> getSearchNodeMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_CONFIG_GENERATION.last());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_TOTAL, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_READY, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_ACTIVE, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_REMOVED, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_DOCS_IN_MEMORY, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DISK_USAGE.last());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MEMORY_USAGE_ALLOCATED_BYTES.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_HEART_BEAT_AGE, EnumSet.of(Suffix.min, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCSUM_DOCS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCSUM_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_QUERY_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_QUERY_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_QUERY_REPLY_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count, Suffix.average));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_REPLY_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_REQUESTED_DOCUMENTS, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_PROTON_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_PROTON_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_PROTON_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_PROTON_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FLUSH_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FLUSH_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FLUSH_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FLUSH_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_MATCH_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_MATCH_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_MATCH_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_MATCH_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_DOCSUM_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_DOCSUM_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_DOCSUM_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_DOCSUM_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_SHARED_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_SHARED_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_SHARED_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_SHARED_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_WARMUP_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_WARMUP_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_WARMUP_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_WARMUP_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FIELD_WRITER_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FIELD_WRITER_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FIELD_WRITER_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FIELD_WRITER_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_EXECUTOR_FIELD_WRITER_SATURATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_TOTAL.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_ATTRIBUTE_FLUSH.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_MEMORY_INDEX_FLUSH.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_DISK_INDEX_FUSION.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_DOCUMENT_STORE_FLUSH.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_DOCUMENT_STORE_COMPACT.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_BUCKET_MOVE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_LID_SPACE_COMPACT.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_JOB_REMOVED_DOCUMENTS_PRUNE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_MASTER_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_MASTER_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_MASTER_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_MASTER_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_INDEX_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_INDEX_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_INDEX_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_INDEX_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_SUMMARY_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_SUMMARY_ACCEPTED.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_SUMMARY_WAKEUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_THREADING_SERVICE_SUMMARY_UTILIZATION, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_LID_SPACE_LID_BLOAT_FACTOR.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_LID_SPACE_LID_FRAGMENTATION_FACTOR.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_LID_SPACE_LID_LIMIT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_LID_SPACE_HIGHEST_USED_LID, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_LID_SPACE_USED_LIDS, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_LID_SPACE_LID_BLOAT_FACTOR.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_LID_SPACE_LID_FRAGMENTATION_FACTOR.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_LID_SPACE_LID_LIMIT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_LID_SPACE_HIGHEST_USED_LID, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_LID_SPACE_USED_LIDS, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_LID_SPACE_LID_BLOAT_FACTOR.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_LID_SPACE_LID_FRAGMENTATION_FACTOR.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_LID_SPACE_LID_LIMIT, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_LID_SPACE_HIGHEST_USED_LID, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_LID_SPACE_USED_LIDS, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_BUCKET_MOVE_BUCKETS_PENDING, EnumSet.of(Suffix.max, Suffix.sum, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK_USAGE_TOTAL.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK_USAGE_TOTAL_UTILIZATION.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK_USAGE_TRANSIENT.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY_USAGE_TOTAL.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY_USAGE_TOTAL_UTILIZATION.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY_USAGE_TRANSIENT.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY_MAPPINGS.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_OPEN_FILE_DESCRIPTORS.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_FEEDING_BLOCKED, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MALLOC_ARENA.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_ATTRIBUTE_RESOURCE_USAGE_ADDRESS_SPACE.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_ATTRIBUTE_RESOURCE_USAGE_FEEDING_BLOCKED.max());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_SETUP, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_READ, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_WRITE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_COMPACT, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_CPU_UTIL_OTHER, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_TRANSACTIONLOG_ENTRIES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_TRANSACTIONLOG_DISK_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_TRANSACTIONLOG_REPLAY_TIME, EnumSet.of(Suffix.max, Suffix.last));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_DISK_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_DISK_BLOAT.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_MAX_BUCKET_SPREAD.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_MEMORY_USAGE_USED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_MEMORY_USAGE_ONHOLD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_DISK_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_DISK_BLOAT.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_MAX_BUCKET_SPREAD.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_MEMORY_USAGE_USED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_MEMORY_USAGE_DEAD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_MEMORY_USAGE_ONHOLD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_DOCUMENT_STORE_DISK_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_DOCUMENT_STORE_DISK_BLOAT.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_DOCUMENT_STORE_MAX_BUCKET_SPREAD.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_DOCUMENT_STORE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_DOCUMENT_STORE_MEMORY_USAGE_USED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_DOCUMENT_STORE_MEMORY_USAGE_DEAD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_REMOVED_DOCUMENT_STORE_MEMORY_USAGE_ONHOLD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_CACHE_MEMORY_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_CACHE_HIT_RATE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_CACHE_LOOKUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_DOCUMENT_STORE_CACHE_INVALIDATIONS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_CACHE_MEMORY_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_CACHE_HIT_RATE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_CACHE_LOOKUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_DOCUMENT_STORE_CACHE_INVALIDATIONS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_ATTRIBUTE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_ATTRIBUTE_MEMORY_USAGE_USED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_ATTRIBUTE_MEMORY_USAGE_DEAD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_ATTRIBUTE_MEMORY_USAGE_ONHOLD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_ATTRIBUTE_DISK_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_ATTRIBUTE_MEMORY_USAGE_ALLOCATED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_ATTRIBUTE_MEMORY_USAGE_USED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_ATTRIBUTE_MEMORY_USAGE_DEAD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_NOTREADY_ATTRIBUTE_MEMORY_USAGE_ONHOLD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_MEMORY_USAGE_ALLOCATED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_MEMORY_USAGE_USED_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_MEMORY_USAGE_DEAD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_MEMORY_USAGE_ONHOLD_BYTES.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_IO_SEARCH_READ_BYTES, EnumSet.of(Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_INDEX_IO_SEARCH_CACHED_READ_BYTES, EnumSet.of(Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_READY_INDEX_DISK_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_POSTINGLIST_MEMORY_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_POSTINGLIST_HIT_RATE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_POSTINGLIST_LOOKUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_POSTINGLIST_INVALIDATIONS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_BITVECTOR_MEMORY_USAGE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_BITVECTOR_HIT_RATE.average());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_BITVECTOR_LOOKUPS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_INDEX_CACHE_BITVECTOR_INVALIDATIONS.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_QUERIES.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_SOFT_DOOMED_QUERIES.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_QUERY_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_QUERY_SETUP_TIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_DOCS_MATCHED, EnumSet.of(Suffix.rate, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERIES.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_SOFT_DOOMED_QUERIES.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_SOFT_DOOM_FACTOR, EnumSet.of(Suffix.min, Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERY_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERY_SETUP_TIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_GROUPING_TIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_RERANK_TIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_DOCS_MATCHED, EnumSet.of(Suffix.rate, Suffix.count));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_LIMITED_QUERIES.rate());
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_FEEDING_COMMIT_OPERATIONS, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count, Suffix.rate));
        VespaMetricSet.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_FEEDING_COMMIT_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        return metrics;
    }

    private static Set<Metric> getStorageMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_DATASTORED_ALLDISKS_BUCKETS.average());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_DATASTORED_ALLDISKS_DOCS.average());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_DATASTORED_ALLDISKS_BYTES.average());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEVISITORLIFETIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEQUEUEWAIT, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_COMPLETED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_CREATED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEMESSAGESENDTIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEPROCESSINGTIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_AVERAGEQUEUEWAIT, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ACTIVE_OPERATIONS_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ACTIVE_OPERATIONS_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_THROTTLE_WINDOW_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_THROTTLE_WAITING_THREADS, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_THROTTLE_ACTIVE_TOKENS, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGEMETADATAREADLATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGEDATAREADLATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGEDATAWRITELATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGE_PUT_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_MERGE_REMOVE_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLSTRIPES_THROTTLED_RPC_DIRECT_DISPATCHES.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLSTRIPES_THROTTLED_PERSISTENCE_THREAD_POLLS.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLSTRIPES_TIMEOUTS_WAITING_FOR_THROTTLE_TOKEN.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_TEST_AND_SET_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_PUT_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_TEST_AND_SET_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_GET_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_GET_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_GET_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_GET_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_TEST_AND_SET_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_UPDATE_REQUEST_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_CREATEITERATOR_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_CREATEITERATOR_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_VISIT_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_VISIT_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_LOCATION_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_LOCATION_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_SPLITBUCKETS_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_JOINBUCKETS_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_DELETEBUCKETS_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_DELETEBUCKETS_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_DELETEBUCKETS_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_BY_GID_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_BY_GID_FAILED.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_REMOVE_BY_GID_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_FILESTOR_ALLTHREADS_SETBUCKETSTATES_COUNT.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_AVERAGEQUEUEWAITINGTIME, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_QUEUESIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_ACTIVE_WINDOW_SIZE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_ESTIMATED_MERGE_MEMORY_USAGE, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_BOUNCED_DUE_TO_BACK_PRESSURE.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_LOCALLYEXECUTEDMERGES_OK.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_MERGECHAINS_OK.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_MERGECHAINS_FAILURES_BUSY.rate());
        VespaMetricSet.addMetric(metrics, StorageMetrics.VDS_MERGETHROTTLER_MERGECHAINS_FAILURES_TOTAL.rate());
        return metrics;
    }

    private static Set<Metric> getDistributorMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS_RECHECKING.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_IDEALSTATE_DIFF.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS_TOOFEWCOPIES.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS_TOOMANYCOPIES.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKETS_NOTRUSTED.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKET_REPLICAS_MOVING_OUT.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKET_REPLICAS_COPYING_OUT.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKET_REPLICAS_COPYING_IN.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_BUCKET_REPLICAS_SYNCING.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MAX_OBSERVED_TIME_SINCE_LAST_GC_SEC.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_DELETE_BUCKET_DONE_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_DELETE_BUCKET_DONE_FAILED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_DELETE_BUCKET_PENDING.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_DONE_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_DONE_FAILED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_PENDING.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_BLOCKED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_THROTTLED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_SOURCE_ONLY_COPY_CHANGED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_SOURCE_ONLY_COPY_DELETE_BLOCKED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_MERGE_BUCKET_SOURCE_ONLY_COPY_DELETE_FAILED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_SPLIT_BUCKET_DONE_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_SPLIT_BUCKET_DONE_FAILED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_SPLIT_BUCKET_PENDING.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_JOIN_BUCKET_DONE_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_JOIN_BUCKET_DONE_FAILED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_JOIN_BUCKET_PENDING.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_GARBAGE_COLLECTION_DONE_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_GARBAGE_COLLECTION_DONE_FAILED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_GARBAGE_COLLECTION_PENDING.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_IDEALSTATE_GARBAGE_COLLECTION_DOCUMENTS_REMOVED, EnumSet.of(Suffix.count, Suffix.rate));
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_TOTAL.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_NOTFOUND.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_TEST_AND_SET_FAILED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_CONCURRENT_MUTATIONS.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_NOTCONNECTED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_NOTREADY.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_WRONGDISTRIBUTOR.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_SAFE_TIME_NOT_REACHED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_STORAGEFAILURE.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_TIMEOUT.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_BUSY.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_PUTS_FAILURES_INCONSISTENT_BUCKET.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_FAILURES_TOTAL.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_FAILURES_NOTFOUND.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_FAILURES_TEST_AND_SET_FAILED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVES_FAILURES_CONCURRENT_MUTATIONS.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_FAILURES_TOTAL.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_FAILURES_NOTFOUND.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_FAILURES_TEST_AND_SET_FAILED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_FAILURES_CONCURRENT_MUTATIONS.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_UPDATES_DIVERGING_TIMESTAMP_UPDATES.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVELOCATIONS_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_REMOVELOCATIONS_FAILURES_TOTAL.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_GETS_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_GETS_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_GETS_FAILURES_TOTAL.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_GETS_FAILURES_NOTFOUND.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_LATENCY, EnumSet.of(Suffix.max, Suffix.sum, Suffix.count));
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_OK.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_TOTAL.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_NOTREADY.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_NOTCONNECTED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_WRONGDISTRIBUTOR.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_SAFE_TIME_NOT_REACHED.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_STORAGEFAILURE.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_TIMEOUT.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_BUSY.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_INCONSISTENT_BUCKET.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_VISITOR_FAILURES_NOTFOUND.rate());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_DOCSSTORED.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_DISTRIBUTOR_BYTESSTORED.average());
        VespaMetricSet.addMetric(metrics, DistributorMetrics.VDS_BOUNCER_CLOCK_SKEW_ABORTS.count());
        return metrics;
    }

    private static void addMetric(Set<Metric> metrics, String nameWithSuffix) {
        metrics.add(new Metric(nameWithSuffix));
    }

    private static void addMetric(Set<Metric> metrics, VespaMetrics metric, EnumSet<Suffix> suffixes) {
        suffixes.forEach(suffix -> metrics.add(new Metric(metric.baseName() + "." + suffix.suffix())));
    }

    private static void addMetric(Set<Metric> metrics, String metricName, Iterable<String> aggregateSuffices) {
        for (String suffix : aggregateSuffices) {
            metrics.add(new Metric(metricName + "." + suffix));
        }
    }
}

