/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics.docs;

import ai.vespa.metrics.VespaMetrics;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MetricDocumentation {
    protected static void writeMetricDocumentation(String path, VespaMetrics[] metrics, String metricType) {
        StringBuilder referenceBuilder = new StringBuilder();
        referenceBuilder.append(String.format("---\n# Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.\ntitle: \"%s Metrics\"\n---\n\n<table class=\"table\">\n  <thead>\n      <tr><th>Name</th><th>Description</th><th>Unit</th></tr>\n  </thead>\n  <tbody>\n%s  </tbody>\n</table>\n", metricType, MetricDocumentation.htmlRows(metrics)));
        try (FileWriter fileWriter = new FileWriter(path + "/" + metricType.toLowerCase() + "-metrics-reference.html");){
            fileWriter.write(referenceBuilder.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String htmlRows(VespaMetrics[] metrics) {
        return Stream.of(metrics).map(metric -> String.format("    <tr>\n      <td><p id=\"%s\">%s</p></td>\n      <td>%s</td>\n      <td>%s</td>\n    </tr>\n", metric.baseName().replaceAll("\\.", "_"), metric.baseName(), metric.description(), metric.unit().toString().toLowerCase())).collect(Collectors.joining());
    }
}

