/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metrics;

import ai.vespa.metrics.Suffix;
import ai.vespa.metrics.Unit;

public interface VespaMetrics {
    public String baseName();

    public Unit unit();

    public String description();

    default public String descriptionWitUnit() {
        return this.description() + " (unit: " + this.unit().shortName() + ")";
    }

    private String withSuffix(Suffix suffix) {
        return this.baseName() + "." + suffix.suffix();
    }

    default public String ninety_five_percentile() {
        return this.withSuffix(Suffix.ninety_five_percentile);
    }

    default public String ninety_nine_percentile() {
        return this.withSuffix(Suffix.ninety_nine_percentile);
    }

    default public String average() {
        return this.withSuffix(Suffix.average);
    }

    default public String count() {
        return this.withSuffix(Suffix.count);
    }

    default public String last() {
        return this.withSuffix(Suffix.last);
    }

    default public String max() {
        return this.withSuffix(Suffix.max);
    }

    default public String min() {
        return this.withSuffix(Suffix.min);
    }

    default public String rate() {
        return this.withSuffix(Suffix.rate);
    }

    default public String sum() {
        return this.withSuffix(Suffix.sum);
    }
}

