/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.metricsproxy.metric.model;

import ai.vespa.metricsproxy.metric.model.prometheus.PrometheusUtil;
import com.yahoo.concurrent.CopyOnWriteHashMap;
import java.util.Map;
import java.util.Objects;

public class MetricId {
    private static final Map<String, MetricId> dictionary = new CopyOnWriteHashMap();
    public static final MetricId empty = MetricId.toMetricId("");
    public final String id;
    private final String idForPrometheus;

    private MetricId(String id) {
        this.id = id;
        this.idForPrometheus = PrometheusUtil.sanitize(id);
    }

    public static MetricId toMetricId(String id) {
        return dictionary.computeIfAbsent(id, MetricId::new);
    }

    public String getIdForPrometheus() {
        return this.idForPrometheus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricId metricId = (MetricId)o;
        return Objects.equals(this.id, metricId.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id;
    }
}

