/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.lucene;

import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.language.Language;
import com.yahoo.language.lucene.DefaultAnalyzers;
import com.yahoo.language.lucene.LuceneAnalysisConfig;
import com.yahoo.language.process.StemMode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

class AnalyzerFactory {
    private static final Logger log = Logger.getLogger(AnalyzerFactory.class.getName());
    private final LuceneAnalysisConfig config;
    private final Map<AnalyzerKey, Analyzer> languageAnalyzers = new ConcurrentHashMap<AnalyzerKey, Analyzer>();
    private final Analyzer defaultAnalyzer = new StandardAnalyzer();
    private static final String STANDARD_TOKENIZER = "standard";
    private final ComponentRegistry<Analyzer> analyzerComponents;
    private final DefaultAnalyzers defaultAnalyzers;

    private static String dump(ComponentRegistry<Analyzer> analyzers) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Map map = analyzers.allComponentsById();
        for (Map.Entry entry : map.entrySet()) {
            buf.append(" {");
            buf.append(((ComponentId)entry.getKey()).toString());
            buf.append(":");
            buf.append(((Analyzer)entry.getValue()).getClass().toString());
            buf.append("}");
        }
        buf.append(" ]");
        return buf.toString();
    }

    public AnalyzerFactory(LuceneAnalysisConfig config, ComponentRegistry<Analyzer> analyzers) {
        this.config = config;
        this.analyzerComponents = analyzers;
        this.defaultAnalyzers = new DefaultAnalyzers();
        log.config("Available in classpath char filters: " + String.valueOf(CharFilterFactory.availableCharFilters()));
        log.config("Available in classpath tokenizers: " + String.valueOf(TokenizerFactory.availableTokenizers()));
        log.config("Available in classpath token filters: " + String.valueOf(TokenFilterFactory.availableTokenFilters()));
        log.config("Available in component registry: " + AnalyzerFactory.dump(analyzers));
    }

    public Analyzer getAnalyzer(Language language, StemMode stemMode, boolean removeAccents) {
        return this.languageAnalyzers.computeIfAbsent(new AnalyzerKey(language, stemMode, removeAccents), this::createAnalyzer);
    }

    private Analyzer createAnalyzer(AnalyzerKey analyzerKey) {
        LuceneAnalysisConfig.Analysis analysis = this.analysisConfig(analyzerKey);
        if (null != analysis) {
            log.config("Creating analyzer for " + String.valueOf(analyzerKey) + " from config");
            return this.createAnalyzer(analyzerKey, analysis);
        }
        Analyzer analyzerFromComponents = this.fromComponents(analyzerKey);
        if (null != analyzerFromComponents) {
            log.config("Using analyzer for " + String.valueOf(analyzerKey) + " from components");
            return analyzerFromComponents;
        }
        if (null != this.defaultAnalyzers.get(analyzerKey.language())) {
            log.config("Using Analyzer for " + String.valueOf(analyzerKey) + " from a list of default language analyzers");
            return this.defaultAnalyzers.get(analyzerKey.language());
        }
        log.config("StandardAnalyzer is used for " + String.valueOf(analyzerKey));
        return this.defaultAnalyzer;
    }

    private LuceneAnalysisConfig.Analysis analysisConfig(AnalyzerKey analyzerKey) {
        LuceneAnalysisConfig.Analysis analysis = this.config.analysis(analyzerKey.languageCodeAndStemMode());
        return null != analysis ? analysis : this.config.analysis(analyzerKey.languageCode());
    }

    private Analyzer fromComponents(AnalyzerKey analyzerKey) {
        Analyzer analyzer = (Analyzer)this.analyzerComponents.getComponent(analyzerKey.languageCodeAndStemMode());
        return null != analyzer ? analyzer : (Analyzer)this.analyzerComponents.getComponent(analyzerKey.languageCode());
    }

    private Analyzer createAnalyzer(AnalyzerKey analyzerKey, LuceneAnalysisConfig.Analysis analysis) {
        try {
            CustomAnalyzer.Builder builder = this.config.configDir().map(CustomAnalyzer::builder).orElseGet(CustomAnalyzer::builder);
            builder = this.withTokenizer(builder, analysis);
            builder = this.addCharFilters(builder, analysis);
            builder = this.addTokenFilters(builder, analysis);
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build analyzer " + String.valueOf(analyzerKey) + ", with configuration " + String.valueOf((Object)analysis), e);
        }
    }

    private CustomAnalyzer.Builder withTokenizer(CustomAnalyzer.Builder builder, LuceneAnalysisConfig.Analysis analysis) throws IOException {
        if (null == analysis) {
            return builder.withTokenizer(STANDARD_TOKENIZER, new HashMap());
        }
        String tokenizerName = analysis.tokenizer().name();
        Map<String, String> conf = analysis.tokenizer().conf();
        return builder.withTokenizer(tokenizerName, this.asModifiable(conf));
    }

    private CustomAnalyzer.Builder addCharFilters(CustomAnalyzer.Builder builder, LuceneAnalysisConfig.Analysis analysis) throws IOException {
        if (null == analysis) {
            return builder;
        }
        for (LuceneAnalysisConfig.Analysis.CharFilters charFilter : analysis.charFilters()) {
            builder.addCharFilter(charFilter.name(), this.asModifiable(charFilter.conf()));
        }
        return builder;
    }

    private CustomAnalyzer.Builder addTokenFilters(CustomAnalyzer.Builder builder, LuceneAnalysisConfig.Analysis analysis) throws IOException {
        if (null == analysis) {
            return builder;
        }
        for (LuceneAnalysisConfig.Analysis.TokenFilters tokenFilter : analysis.tokenFilters()) {
            builder.addTokenFilter(tokenFilter.name(), this.asModifiable(tokenFilter.conf()));
        }
        return builder;
    }

    private Map<String, String> asModifiable(Map<String, String> map) {
        return new HashMap<String, String>(map);
    }

    private record AnalyzerKey(Language language, StemMode stemMode, boolean removeAccents) {
        public String languageCodeAndStemMode() {
            return this.language.languageCode() + "/" + this.stemMode.toString();
        }

        public String languageCode() {
            return this.language.languageCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnalyzerKey)) {
                return false;
            }
            AnalyzerKey other = (AnalyzerKey)o;
            return other.language == this.language && other.stemMode == this.stemMode;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.language, this.stemMode);
        }
    }
}

