// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.language.lucene;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of lucene-analysis
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class LuceneAnalysisConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "8693aedc2ccd03cddde9c61d304e0560";
  public final static String CONFIG_DEF_NAME = "lucene-analysis";
  public final static String CONFIG_DEF_NAMESPACE = "com.yahoo.language.lucene";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=com.yahoo.language.lucene",
    "configDir path optional",
    "analysis{}.tokenizer.name string default=standard",
    "analysis{}.tokenizer.conf{} string",
    "analysis{}.charFilters[].name string",
    "analysis{}.charFilters[].conf{} string",
    "analysis{}.tokenFilters[].name string",
    "analysis{}.tokenFilters[].conf{} string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Optional<FileReference> configDir = Optional.empty();
    public Map<String, Analysis.Builder> analysis = new LinkedHashMap<>();

    public Builder() { }

    public Builder(LuceneAnalysisConfig config) {
      configDir(config.configDir.getFileReference());
      for (Map.Entry<String, Analysis> __entry : config.analysis().entrySet()) {
        analysis(__entry.getKey(), new Analysis.Builder(__entry.getValue()));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.configDir != null)
        configDir(__superior.configDir);
      analysis(__superior.analysis);
      return this;
    }

    public Builder configDir(Optional<FileReference> __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      configDir = __value;
      __uninitialized.remove("configDir");
      return this;
    }

    private Builder configDir(FileReference __value) {
      return configDir(Optional.of(__value));
    }

    public Builder analysis(String __key, Analysis.Builder __value) {
      analysis.put(__key, __value);
      return this;
    }

    public Builder analysis(Map<String, Analysis.Builder> __values) {
      analysis.putAll(__values);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before using it as the value
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder analysis(String __key, java.util.function.Consumer<Analysis.Builder> __func) {
      Analysis.Builder __inner = new Analysis.Builder();
      __func.accept(__inner);
      analysis.put(__key, __inner);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public LuceneAnalysisConfig build() {
      return new LuceneAnalysisConfig(this);
    }

  }

  // The schema ("type") for an application specified config type
  // See
  // - https://docs.vespa.ai/en/reference/config-files.html
  private final OptionalPathNode configDir;
  private final Map<String, Analysis> analysis;

  public LuceneAnalysisConfig(Builder builder) {
    this(builder, true);
  }

  private LuceneAnalysisConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "lucene-analysis must be initialized: " + builder.__uninitialized);

    configDir = (builder.configDir == null) ?
        new OptionalPathNode() : new OptionalPathNode(builder.configDir);
    analysis = Analysis.createMap(builder.analysis);
  }

  /**
   * @return lucene-analysis.configDir
   */
  public Optional<Path> configDir() {
    return configDir.value();
  }

  /**
   * @return lucene-analysis.analysis{}
   */
  public Map<String, Analysis> analysis() {
    return Collections.unmodifiableMap(analysis);
  }

  /**
   * @param key the key of the value to return
   * @return lucene-analysis.analysis{}
   */
  public Analysis analysis(String key) {
    return analysis.get(key);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(LuceneAnalysisConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("lucene-analysis");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents lucene-analysis.analysis{}
   */
  public final static class Analysis extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public Tokenizer.Builder tokenizer = new Tokenizer.Builder();
      public List<CharFilters.Builder> charFilters = new ArrayList<>();
      public List<TokenFilters.Builder> tokenFilters = new ArrayList<>();

      public Builder() { }

      public Builder(Analysis config) {
        tokenizer(new Tokenizer.Builder(config.tokenizer()));
        for (CharFilters c : config.charFilters()) {
          charFilters(new CharFilters.Builder(c));
        }
        for (TokenFilters t : config.tokenFilters()) {
          tokenFilters(new TokenFilters.Builder(t));
        }
      }

      private Builder override(Builder __superior) {
        tokenizer(tokenizer.override(__superior.tokenizer));
        if (!__superior.charFilters.isEmpty())
          charFilters.addAll(__superior.charFilters);
        if (!__superior.tokenFilters.isEmpty())
          tokenFilters.addAll(__superior.tokenFilters);
        return this;
      }

      public Builder tokenizer(Tokenizer.Builder __builder) {
        tokenizer = __builder;
        return this;
      }
      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder tokenizer(java.util.function.Consumer<Tokenizer.Builder> __func) {
        Tokenizer.Builder __inner = new Tokenizer.Builder();
        __func.accept(__inner);
        tokenizer = __inner;
        return this;
      }

      /**
       * Add the given builder to this builder's list of CharFilters builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder charFilters(CharFilters.Builder __builder) {
        charFilters.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder charFilters(java.util.function.Consumer<CharFilters.Builder> __func) {
        CharFilters.Builder __inner = new CharFilters.Builder();
        __func.accept(__inner);
        charFilters.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of CharFilters builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder charFilters(List<CharFilters.Builder> __builders) {
        charFilters = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of TokenFilters builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder tokenFilters(TokenFilters.Builder __builder) {
        tokenFilters.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder tokenFilters(java.util.function.Consumer<TokenFilters.Builder> __func) {
        TokenFilters.Builder __inner = new TokenFilters.Builder();
        __func.accept(__inner);
        tokenFilters.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of TokenFilters builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder tokenFilters(List<TokenFilters.Builder> __builders) {
        tokenFilters = __builders;
        return this;
      }

      public Analysis build() {
        return new Analysis(this);
      }

    }

    private final Tokenizer tokenizer;
    private final InnerNodeVector<CharFilters> charFilters;
    private final InnerNodeVector<TokenFilters> tokenFilters;

    public Analysis(Builder builder) {
      this(builder, true);
    }

    private Analysis(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "lucene-analysis.analysis{} must be initialized: " + builder.__uninitialized);

      tokenizer = new Tokenizer(builder.tokenizer, throwIfUninitialized);
      charFilters = CharFilters.createVector(builder.charFilters);
      tokenFilters = TokenFilters.createVector(builder.tokenFilters);
    }

    /**
     * @return lucene-analysis.analysis{}.tokenizer
     */
    public Tokenizer tokenizer() {
      return tokenizer;
    }

    /**
     * @return lucene-analysis.analysis{}.charFilters[]
     */
    public List<CharFilters> charFilters() {
      return charFilters;
    }

    /**
     * @param i the index of the value to return
     * @return lucene-analysis.analysis{}.charFilters[]
     */
    public CharFilters charFilters(int i) {
      return charFilters.get(i);
    }

    /**
     * @return lucene-analysis.analysis{}.tokenFilters[]
     */
    public List<TokenFilters> tokenFilters() {
      return tokenFilters;
    }

    /**
     * @param i the index of the value to return
     * @return lucene-analysis.analysis{}.tokenFilters[]
     */
    public TokenFilters tokenFilters(int i) {
      return tokenFilters.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Analysis newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("analysis");
      return changes;
    }

    private static Map<String, Analysis> createMap(Map<String, Builder> builders) {
      Map<String, Analysis> ret = new LinkedHashMap<>();
      for(String key : builders.keySet()) {
        ret.put(key, new Analysis(builders.get(key)));
      }
      return Collections.unmodifiableMap(ret);
    }

    /**
     * This class represents lucene-analysis.analysis{}.tokenizer
     */
    public final static class Tokenizer extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        private String name = null;
        public Map<String, String> conf = new LinkedHashMap<>();

        public Builder() { }

        public Builder(Tokenizer config) {
          name(config.name());
          conf(config.conf());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          conf(__superior.conf);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          return this;
        }


        public Builder conf(String __key, String __value) {
          conf.put(__key, __value);
          return this;
        }

        public Builder conf(Map<String, String> __values) {
          conf.putAll(__values);
          return this;
        }

        public Tokenizer build() {
          return new Tokenizer(this);
        }

      }

      private final StringNode name;
      private final Map<String, StringNode> conf;

      public Tokenizer(Builder builder) {
        this(builder, true);
      }

      private Tokenizer(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "lucene-analysis.analysis{}.tokenizer must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode("standard") : new StringNode(builder.name);
        conf = LeafNodeMaps.asNodeMap(builder.conf, new StringNode());
      }

      /**
       * @return lucene-analysis.analysis{}.tokenizer.name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return lucene-analysis.analysis{}.tokenizer.conf{}
       */
      public Map<String, String> conf() {
        return LeafNodeMaps.asValueMap(conf);
      }

      /**
       * @param key the key of the value to return
       * @return lucene-analysis.analysis{}.tokenizer.conf{}
       */
      public String conf(String key) {
        return conf.get(key).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Tokenizer newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("tokenizer");
        return changes;
      }
    }

    /**
     * This class represents lucene-analysis.analysis{}.charFilters[]
     */
    public final static class CharFilters extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;
        public Map<String, String> conf = new LinkedHashMap<>();

        public Builder() { }

        public Builder(CharFilters config) {
          name(config.name());
          conf(config.conf());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          conf(__superior.conf);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder conf(String __key, String __value) {
          conf.put(__key, __value);
          return this;
        }

        public Builder conf(Map<String, String> __values) {
          conf.putAll(__values);
          return this;
        }

        public CharFilters build() {
          return new CharFilters(this);
        }

      }

      private final StringNode name;
      private final Map<String, StringNode> conf;

      public CharFilters(Builder builder) {
        this(builder, true);
      }

      private CharFilters(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "lucene-analysis.analysis{}.charFilters[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        conf = LeafNodeMaps.asNodeMap(builder.conf, new StringNode());
      }

      /**
       * @return lucene-analysis.analysis{}.charFilters[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return lucene-analysis.analysis{}.charFilters[].conf{}
       */
      public Map<String, String> conf() {
        return LeafNodeMaps.asValueMap(conf);
      }

      /**
       * @param key the key of the value to return
       * @return lucene-analysis.analysis{}.charFilters[].conf{}
       */
      public String conf(String key) {
        return conf.get(key).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(CharFilters newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("charFilters");
        return changes;
      }

      private static InnerNodeVector<CharFilters> createVector(List<Builder> builders) {
          List<CharFilters> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new CharFilters(b));
          }
          return new InnerNodeVector<CharFilters>(elems);
      }
    }

    /**
     * This class represents lucene-analysis.analysis{}.tokenFilters[]
     */
    public final static class TokenFilters extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;
        public Map<String, String> conf = new LinkedHashMap<>();

        public Builder() { }

        public Builder(TokenFilters config) {
          name(config.name());
          conf(config.conf());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          conf(__superior.conf);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder conf(String __key, String __value) {
          conf.put(__key, __value);
          return this;
        }

        public Builder conf(Map<String, String> __values) {
          conf.putAll(__values);
          return this;
        }

        public TokenFilters build() {
          return new TokenFilters(this);
        }

      }

      private final StringNode name;
      private final Map<String, StringNode> conf;

      public TokenFilters(Builder builder) {
        this(builder, true);
      }

      private TokenFilters(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "lucene-analysis.analysis{}.tokenFilters[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        conf = LeafNodeMaps.asNodeMap(builder.conf, new StringNode());
      }

      /**
       * @return lucene-analysis.analysis{}.tokenFilters[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return lucene-analysis.analysis{}.tokenFilters[].conf{}
       */
      public Map<String, String> conf() {
        return LeafNodeMaps.asValueMap(conf);
      }

      /**
       * @param key the key of the value to return
       * @return lucene-analysis.analysis{}.tokenFilters[].conf{}
       */
      public String conf(String key) {
        return conf.get(key).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(TokenFilters newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("tokenFilters");
        return changes;
      }

      private static InnerNodeVector<TokenFilters> createVector(List<Builder> builders) {
          List<TokenFilters> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new TokenFilters(b));
          }
          return new InnerNodeVector<TokenFilters>(elems);
      }
    }
  }

}
