/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.language.LinguisticsCase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SpecialTokens {
    private static final SpecialTokens empty = new SpecialTokens("(empty)", List.of());
    private final String name;
    private final int maximumLength;
    private final List<Token> tokens;
    private final Map<String, String> tokenMap;

    public SpecialTokens(String name, List<Token> tokens) {
        tokens.stream().peek(token -> token.validate());
        ArrayList<Token> mutableTokens = new ArrayList<Token>(tokens);
        Collections.sort(mutableTokens);
        this.name = name;
        this.maximumLength = tokens.stream().mapToInt(token -> token.token().length()).max().orElse(0);
        this.tokens = List.copyOf(mutableTokens);
        this.tokenMap = tokens.stream().collect(Collectors.toUnmodifiableMap(t -> t.token(), t -> t.replacement()));
    }

    public String name() {
        return this.name;
    }

    public Map<String, String> asMap() {
        return this.tokenMap;
    }

    public Token tokenize(String string, boolean substring) {
        String input = LinguisticsCase.toLowerCase(string.substring(0, Math.min(string.length(), this.maximumLength)));
        for (Token special : this.tokens) {
            if (!input.startsWith(special.token()) || string.length() != special.token().length() && !substring && !this.tokenEndsAt(special.token().length(), string)) continue;
            return special;
        }
        return null;
    }

    private boolean tokenEndsAt(int position, String string) {
        return !Character.isLetterOrDigit(string.charAt(position));
    }

    public static SpecialTokens empty() {
        return empty;
    }

    public static final class Token
    implements Comparable<Token> {
        private final String token;
        private final String replacement;

        public Token(String token) {
            this(token, null);
        }

        public Token(String token, String replacement) {
            this.token = LinguisticsCase.toLowerCase(token);
            this.replacement = replacement == null || replacement.trim().equals("") ? this.token : LinguisticsCase.toLowerCase(replacement);
        }

        public String token() {
            return this.token;
        }

        public String replacement() {
            return this.replacement;
        }

        @Override
        public int compareTo(Token other) {
            if (this.token().length() < other.token().length()) {
                return 1;
            }
            if (this.token().length() == other.token().length()) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            return Objects.equals(this.token, ((Token)other).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public String toString() {
            return "token '" + this.token + "'" + (String)(this.replacement.equals(this.token) ? "" : " replacement '" + this.replacement + "'");
        }

        private void validate() {
            String asLow = LinguisticsCase.toLowerCase(this.token);
            String asHigh = this.token.toUpperCase(Locale.ENGLISH);
            if (asLow.length() != this.token.length() || asHigh.length() != this.token.length()) {
                throw new IllegalArgumentException("Special token '" + this.token + "' has case sensitive length. Please report this to the Vespa team.");
            }
        }
    }
}

