/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language;

import java.util.Locale;
import java.util.Objects;

public final class LocaleFactory {
    private static final Locale UNKNOWN = Locale.ROOT;

    private LocaleFactory() {
    }

    public static Locale fromLanguageTag(String tag) {
        Objects.requireNonNull(tag, "tag cannot be null");
        tag = tag.trim();
        if (tag.isEmpty()) {
            return UNKNOWN;
        }
        String language = "";
        String region = "";
        String script = "";
        String[] parts = tag.split("-");
        for (int partIdx = 0; partIdx < parts.length; ++partIdx) {
            String part = parts[partIdx];
            int partLen = part.length();
            if (partIdx == 0) {
                if (partLen != 2 && partLen != 3) continue;
                language = part;
                continue;
            }
            if (partIdx != 1 && partIdx != 2) continue;
            if (partLen == 2 || partLen == 3) {
                region = part;
                continue;
            }
            if (partLen != 4) continue;
            script = part;
        }
        if (language.isEmpty()) {
            return UNKNOWN;
        }
        return new Locale.Builder().setLanguage(language).setScript(script).setRegion(region).build();
    }
}

