/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.process;

import com.yahoo.collections.LazyMap;
import com.yahoo.language.process.InvocationContext;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface Chunker {
    public static final String defaultChunkerId = "default";
    public static final Chunker throwsOnUse = new FailingChunker();

    default public Map<String, Chunker> asMap() {
        return this.asMap(defaultChunkerId);
    }

    default public Map<String, Chunker> asMap(String name) {
        return Map.of(name, this);
    }

    public List<Chunk> chunk(String var1, Context var2);

    public static class FailingChunker
    implements Chunker {
        private final String message;

        public FailingChunker() {
            this("No chunker has been configured");
        }

        public FailingChunker(String message) {
            this.message = message;
        }

        @Override
        public List<Chunk> chunk(String text, Context context) {
            throw new IllegalStateException(this.message);
        }

        public boolean equals(Object other) {
            return other.getClass().getName().equals(this.getClass().getName());
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }

        public static Function<String, Chunker> factory() {
            return FailingChunker::new;
        }
    }

    public static class Context
    extends InvocationContext<Context> {
        private final List<String> arguments;

        public Context(String destination) {
            this(destination, List.of(), (Map<Object, Object>)LazyMap.newHashMap());
        }

        public Context(String destination, List<String> arguments, Map<Object, Object> cache) {
            super(destination, cache);
            this.arguments = List.copyOf(arguments);
        }

        public List<String> arguments() {
            return this.arguments;
        }
    }

    public record Chunk(String text) {
        @Override
        public String toString() {
            return "chunk '" + this.text() + "'";
        }
    }
}

