/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DataArray
extends Value {
    private byte[][] value;

    public DataArray(byte[][] value) {
        this.value = value;
    }

    DataArray(ByteBuffer src) {
        int size = src.getInt();
        this.value = new byte[size][];
        for (int i = 0; i < size; ++i) {
            this.value[i] = new byte[src.getInt()];
            src.get(this.value[i]);
        }
    }

    @Override
    public byte type() {
        return 88;
    }

    @Override
    public int count() {
        return this.value.length;
    }

    @Override
    int bytes() {
        int bytes = 4;
        for (int i = 0; i < this.value.length; ++i) {
            bytes += 4 + this.value[i].length;
        }
        return bytes;
    }

    @Override
    void encode(ByteBuffer dst) {
        dst.putInt(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            dst.putInt(this.value[i].length);
            dst.put(this.value[i]);
        }
    }

    @Override
    public byte[][] asDataArray() {
        return this.value;
    }

    @Override
    public String toString() {
        return Arrays.toString((Object[])this.value);
    }
}

