/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.Value;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DoubleArray
extends Value {
    private double[] value;

    public DoubleArray(double[] value) {
        this.value = value;
    }

    DoubleArray(ByteBuffer src) {
        int size = src.getInt();
        this.value = new double[size];
        src.asDoubleBuffer().get(this.value);
        src.position(src.position() + size * 8);
    }

    @Override
    public byte type() {
        return 68;
    }

    @Override
    public int count() {
        return this.value.length;
    }

    @Override
    int bytes() {
        return 4 + this.value.length * 8;
    }

    @Override
    void encode(ByteBuffer dst) {
        dst.putInt(this.value.length);
        dst.asDoubleBuffer().put(this.value);
        dst.position(dst.position() + this.value.length * 8);
    }

    @Override
    public double[] asDoubleArray() {
        return this.value;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.value);
    }
}

