/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

class Queue {
    private Object[] buf;
    private int used;
    private int readPos;
    private int writePos;

    private void ensureFree(int need) {
        if (this.buf.length < this.used + need) {
            int newSize;
            for (newSize = Math.max(this.buf.length, 8); newSize < this.used + need; newSize *= 2) {
            }
            Object[] newBuf = new Object[newSize];
            for (int i = 0; i < this.used; ++i) {
                newBuf[i] = this.buf[this.readPos++];
                if (this.readPos != this.buf.length) continue;
                this.readPos = 0;
            }
            this.buf = newBuf;
            this.readPos = 0;
            this.writePos = this.used;
        }
    }

    public Queue(int capacity) {
        this.buf = new Object[capacity];
        this.used = 0;
        this.readPos = 0;
        this.writePos = 0;
    }

    public Queue() {
        this(64);
    }

    public void enqueue(Object obj) {
        this.ensureFree(1);
        this.buf[this.writePos++] = obj;
        if (this.writePos == this.buf.length) {
            this.writePos = 0;
        }
        ++this.used;
    }

    public Object dequeue() {
        if (this.used == 0) {
            return null;
        }
        Object obj = this.buf[this.readPos];
        this.buf[this.readPos++] = null;
        if (this.readPos == this.buf.length) {
            this.readPos = 0;
        }
        --this.used;
        return obj;
    }

    public boolean isEmpty() {
        return this.used == 0;
    }

    public int size() {
        return this.used;
    }

    public int flush(Queue dst) {
        int cnt = this.used;
        dst.ensureFree(cnt);
        for (int i = 0; i < this.used; ++i) {
            dst.buf[dst.writePos++] = this.buf[this.readPos];
            this.buf[this.readPos++] = null;
            if (dst.writePos == dst.buf.length) {
                dst.writePos = 0;
            }
            if (this.readPos != this.buf.length) continue;
            this.readPos = 0;
        }
        dst.used += this.used;
        this.used = 0;
        return cnt;
    }
}

