/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jrt;

import com.yahoo.jrt.CryptoEngine;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.TlsCryptoSocket;
import com.yahoo.security.tls.TlsContext;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;

public class TlsCryptoEngine
implements CryptoEngine {
    private final TlsContext tlsContext;

    public TlsCryptoEngine(TlsContext tlsContext) {
        this.tlsContext = tlsContext;
    }

    @Override
    public TlsCryptoSocket createClientCryptoSocket(SocketChannel channel, Spec spec) {
        String peerHost = spec.host() != null ? spec.host() : "localhost";
        SSLEngine sslEngine = this.tlsContext.createSslEngine(peerHost, spec.port());
        sslEngine.setUseClientMode(true);
        return new TlsCryptoSocket(channel, sslEngine);
    }

    @Override
    public TlsCryptoSocket createServerCryptoSocket(SocketChannel channel) {
        SSLEngine sslEngine = this.tlsContext.createSslEngine();
        sslEngine.setUseClientMode(false);
        return new TlsCryptoSocket(channel, sslEngine);
    }

    @Override
    public void close() {
        this.tlsContext.close();
    }
}

