/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class ExpressionList<T extends Expression>
extends CompositeExpression
implements Iterable<T> {
    private final List<T> expressions = new ArrayList<T>();

    protected ExpressionList(Iterable<? extends T> expressions) {
        for (Expression exp : expressions) {
            this.expressions.add((T)((Object)exp));
        }
    }

    @Override
    public boolean requiresInput() {
        return !this.expressions.isEmpty() && ((Expression)((Object)this.expressions.get(0))).requiresInput();
    }

    public List<T> expressions() {
        return this.expressions;
    }

    protected List<Expression> convertChildList(ExpressionConverter converter) {
        return this.asList().stream().map(converter::convert).filter(Objects::nonNull).toList();
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        for (Expression expression : this.expressions) {
            expression.setStatementOutput(documentType, field);
        }
    }

    public int size() {
        return this.expressions.size();
    }

    public T get(int idx) {
        return (T)((Object)((Expression)((Object)this.expressions.get(idx))));
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    public List<T> asList() {
        return Collections.unmodifiableList(this.expressions);
    }

    @Override
    public Iterator<T> iterator() {
        return this.expressions.iterator();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpressionList)) {
            return false;
        }
        ExpressionList rhs = (ExpressionList)obj;
        return this.expressions.equals(rhs.expressions);
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.expressions.hashCode();
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        for (Expression exp : this.expressions) {
            exp.select(predicate, operation);
        }
    }
}

