/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.collections.LazyMap;
import com.yahoo.document.DocumentId;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.detect.Detection;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValues;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExecutionContext {
    private final Map<String, FieldValue> variables = new HashMap<String, FieldValue>();
    private final FieldValues fieldValues;
    private FieldValue currentValue;
    private Language assignedLanguage = Language.UNKNOWN;
    private Language detectedLanguage = Language.UNKNOWN;
    private final Map<Object, Object> cache = LazyMap.newHashMap();
    private DocumentId documentId;
    private boolean isReindexingOperation;

    public ExecutionContext() {
        this(null);
    }

    public ExecutionContext(FieldValues fieldValue) {
        this.fieldValues = fieldValue;
    }

    public ExecutionContext execute(Expression expression) {
        if (expression != null) {
            expression.execute(this);
        }
        return this;
    }

    public boolean isComplete() {
        return this.fieldValues != null && this.fieldValues.isComplete();
    }

    public FieldValue getFieldValue(String fieldName) {
        return this.fieldValues.getInputValue(fieldName);
    }

    public FieldValue getFieldValue(FieldPath fieldPath) {
        return this.fieldValues.getInputValue(fieldPath);
    }

    public ExecutionContext setFieldValue(String fieldName, FieldValue fieldValue, Expression expression) {
        this.fieldValues.setOutputValue(fieldName, fieldValue, expression);
        return this;
    }

    public FieldValues getFieldValues() {
        return this.fieldValues;
    }

    public FieldValue getVariable(String name) {
        return this.variables.get(name);
    }

    public ExecutionContext setVariable(String name, FieldValue value) {
        this.variables.put(name, value);
        return this;
    }

    public FieldValue getCurrentValue() {
        return this.currentValue;
    }

    public ExecutionContext setCurrentValue(FieldValue value) {
        this.currentValue = value;
        return this;
    }

    public Object getCachedValue(Object key) {
        return this.cache.get(key);
    }

    public void putCachedValue(String key, Object value) {
        this.cache.put(key, value);
    }

    public Map<Object, Object> getCache() {
        return this.cache;
    }

    public Language getLanguage() {
        if (this.assignedLanguage != Language.UNKNOWN) {
            return this.assignedLanguage;
        }
        return this.detectedLanguage;
    }

    public ExecutionContext setLanguage(Language language) {
        this.assignedLanguage = Objects.requireNonNull(language);
        return this;
    }

    public Language resolveLanguage(Linguistics linguistics) {
        if (this.assignedLanguage != Language.UNKNOWN) {
            return this.assignedLanguage;
        }
        if (linguistics == null) {
            return Language.ENGLISH;
        }
        Detection detection = linguistics.getDetector().detect(String.valueOf(this.currentValue), null);
        if (detection == null) {
            return Language.ENGLISH;
        }
        this.detectedLanguage = detection.getLanguage();
        if (this.detectedLanguage == Language.UNKNOWN) {
            this.detectedLanguage = Language.ENGLISH;
        }
        return this.detectedLanguage;
    }

    public boolean isReindexingOperation() {
        return this.isReindexingOperation;
    }

    public ExecutionContext setReindexingOperation() {
        this.isReindexingOperation = true;
        return this;
    }

    public Optional<DocumentId> getDocumentId() {
        return Optional.ofNullable(this.documentId);
    }

    public ExecutionContext setDocumentId(DocumentId id) {
        this.documentId = Objects.requireNonNull(id);
        return this;
    }

    public ExecutionContext clear() {
        this.variables.clear();
        this.currentValue = null;
        this.documentId = null;
        this.isReindexingOperation = false;
        return this;
    }
}

