/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.process.Chunker;
import com.yahoo.vespa.indexinglanguage.expressions.Components;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.TypeContext;
import java.util.List;
import java.util.Objects;

public class ChunkExpression
extends Expression {
    private final Components.Selected<Chunker> chunker;
    private String destination;

    public ChunkExpression(Components<Chunker> chunkers, String chunkerId, List<String> chunkerArguments) {
        this.chunker = new Components.Selected<Chunker>("chunker", chunkers, chunkerId, false, chunkerArguments);
    }

    @Override
    public DataType setInputType(DataType inputType, TypeContext context) {
        super.setInputType(inputType, (DataType)DataType.STRING, context);
        return ArrayDataType.getArray((DataType)DataType.STRING);
    }

    @Override
    public DataType setOutputType(DataType outputType, TypeContext context) {
        super.setOutputType((DataType)ArrayDataType.getArray((DataType)DataType.STRING), outputType, null, context);
        return DataType.STRING;
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.destination = documentType.getName() + "." + field.getName();
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        String input = String.valueOf(context.getCurrentValue());
        Array output = new Array((DataType)DataType.getArray((DataType)DataType.STRING));
        if (!input.isEmpty()) {
            Chunker.Context chunkContext = new Chunker.Context(this.destination, this.chunker.arguments(), context.getCache());
            for (Chunker.Chunk chunk : this.chunker.component().chunk(input, chunkContext)) {
                output.add((FieldValue)new StringFieldValue(chunk.text()));
            }
        }
        context.setCurrentValue((FieldValue)output);
    }

    public String toString() {
        return "chunk" + this.chunker.argumentsString();
    }

    public int hashCode() {
        return Objects.hash(ChunkExpression.class, this.chunker);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChunkExpression)) {
            return false;
        }
        ChunkExpression other = (ChunkExpression)((Object)o);
        return other.chunker.equals(this.chunker);
    }
}

