/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.update.AddValueUpdate;
import com.yahoo.document.update.ArithmeticValueUpdate;
import com.yahoo.document.update.AssignValueUpdate;
import com.yahoo.document.update.ClearValueUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.RemoveValueUpdate;
import com.yahoo.document.update.TensorAddUpdate;
import com.yahoo.document.update.TensorModifyUpdate;
import com.yahoo.document.update.TensorRemoveUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.vespa.indexinglanguage.DocumentFieldValues;
import com.yahoo.vespa.indexinglanguage.UpdateFieldValues;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValues;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FieldUpdateFieldValues
implements UpdateFieldValues {
    private final DocumentFieldValues values;
    private final Builder builder;
    private final Expression optimizedExpression;

    private FieldUpdateFieldValues(Expression optimizedExpression, DocumentFieldValues values, Builder builder) {
        this.values = values;
        this.builder = builder;
        this.optimizedExpression = optimizedExpression;
    }

    @Override
    public DocumentUpdate getOutput() {
        Document doc = this.values.getUpdatableOutput();
        DocumentUpdate update = new DocumentUpdate(doc.getDataType(), doc.getId());
        for (Map.Entry entry : doc) {
            Field field = (Field)entry.getKey();
            if (field.getName().equals("sddocname")) continue;
            FieldUpdate fieldUpdate = FieldUpdate.create((Field)field);
            fieldUpdate.addValueUpdates(this.builder.build((FieldValue)entry.getValue()));
            if (fieldUpdate.isEmpty()) continue;
            update.addFieldUpdate(fieldUpdate);
        }
        return update.isEmpty() ? null : update;
    }

    @Override
    public Expression getExpression(Expression expression) {
        return this.optimizedExpression != null ? this.optimizedExpression : expression;
    }

    @Override
    public DataType getFieldType(String fieldName, Expression exp) {
        return this.values.getFieldType(fieldName, exp);
    }

    @Override
    public FieldValue getInputValue(String fieldName) {
        return this.values.getInputValue(fieldName);
    }

    @Override
    public FieldValue getInputValue(FieldPath fieldPath) {
        return this.values.getInputValue(fieldPath);
    }

    @Override
    public FieldValues setOutputValue(String fieldName, FieldValue fieldValue, Expression exp) {
        return this.values.setOutputValue(fieldName, fieldValue, exp);
    }

    public String toString() {
        return "field update values: " + String.valueOf(this.values);
    }

    public static FieldUpdateFieldValues fromPartialUpdate(DocumentFieldValues documentFieldValues, ValueUpdate valueUpdate) {
        return new FieldUpdateFieldValues(null, documentFieldValues, new PartialBuilder(valueUpdate));
    }

    public static FieldUpdateFieldValues fromPartialUpdate(Expression expression, DocumentFieldValues documentFieldValues, ValueUpdate valueUpdate) {
        return new FieldUpdateFieldValues(expression, documentFieldValues, new PartialBuilder(valueUpdate));
    }

    public static FieldUpdateFieldValues fromCompleteUpdate(DocumentFieldValues documentFieldValues) {
        return new FieldUpdateFieldValues(null, documentFieldValues, new CompleteBuilder());
    }

    private static interface Builder {
        public List<ValueUpdate> build(FieldValue var1);
    }

    private static class PartialBuilder
    implements Builder {
        final ValueUpdate update;

        PartialBuilder(ValueUpdate update) {
            this.update = update;
        }

        @Override
        public List<ValueUpdate> build(FieldValue val) {
            return this.createValueUpdates(val, this.update);
        }

        List<ValueUpdate> createValueUpdates(FieldValue value, ValueUpdate update) {
            ArrayList<ValueUpdate> valueUpdates = new ArrayList<ValueUpdate>();
            if (update instanceof ClearValueUpdate) {
                valueUpdates.add((ValueUpdate)new ClearValueUpdate());
            } else if (update instanceof AssignValueUpdate) {
                valueUpdates.add((ValueUpdate)new AssignValueUpdate(value));
            } else if (update instanceof AddValueUpdate) {
                if (value instanceof Array) {
                    valueUpdates.addAll(this.createAddValueUpdateForArray((Array)value, ((AddValueUpdate)update).getWeight()));
                } else if (value instanceof WeightedSet) {
                    valueUpdates.addAll(this.createAddValueUpdateForWset((WeightedSet)value));
                }
            } else if (update instanceof ArithmeticValueUpdate) {
                valueUpdates.add(update);
            } else if (update instanceof RemoveValueUpdate) {
                if (value instanceof Array) {
                    valueUpdates.addAll(this.createRemoveValueUpdateForEachElement(((Array)value).fieldValueIterator()));
                } else if (value instanceof WeightedSet) {
                    valueUpdates.addAll(this.createRemoveValueUpdateForEachElement(((WeightedSet)value).fieldValueIterator()));
                }
            } else if (update instanceof MapValueUpdate) {
                if (value instanceof Array) {
                    valueUpdates.addAll(this.createMapValueUpdatesForArray((Array)value, (MapValueUpdate)update));
                } else {
                    if (value instanceof MapFieldValue) {
                        throw new UnsupportedOperationException("Can not map into a " + value.getClass().getName());
                    }
                    if (value instanceof StructuredFieldValue) {
                        valueUpdates.addAll(this.createMapValueUpdatesForStruct((StructuredFieldValue)value, (MapValueUpdate)update));
                    } else if (value instanceof WeightedSet) {
                        valueUpdates.addAll(this.createMapValueUpdatesForWset((WeightedSet)value, (MapValueUpdate)update));
                    }
                }
            } else if (update instanceof TensorModifyUpdate) {
                valueUpdates.add(update);
            } else if (update instanceof TensorAddUpdate) {
                valueUpdates.add(update);
            } else if (update instanceof TensorRemoveUpdate) {
                valueUpdates.add(update);
            } else {
                throw new UnsupportedOperationException("Value update type " + update.getClass().getName() + " not supported");
            }
            return valueUpdates;
        }

        private List<ValueUpdate> createAddValueUpdateForArray(Array arr, int weight) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>(arr.size());
            Iterator it = arr.fieldValueIterator();
            while (it.hasNext()) {
                ret.add((ValueUpdate)new AddValueUpdate((FieldValue)it.next(), weight));
            }
            return ret;
        }

        private List<ValueUpdate> createAddValueUpdateForWset(WeightedSet wset) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>(wset.size());
            Iterator it = wset.fieldValueIterator();
            while (it.hasNext()) {
                FieldValue key = (FieldValue)it.next();
                ret.add((ValueUpdate)new AddValueUpdate(key, wset.get((Object)key).intValue()));
            }
            return ret;
        }

        private List<ValueUpdate> createRemoveValueUpdateForEachElement(Iterator<FieldValue> it) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>();
            while (it.hasNext()) {
                ret.add((ValueUpdate)new RemoveValueUpdate(it.next()));
            }
            return ret;
        }

        private List<ValueUpdate> createMapValueUpdatesForArray(Array arr, MapValueUpdate upd) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>();
            Iterator it = arr.fieldValueIterator();
            while (it.hasNext()) {
                FieldValue childVal = (FieldValue)it.next();
                for (ValueUpdate childUpd : this.createValueUpdates(childVal, upd.getUpdate())) {
                    ret.add((ValueUpdate)new MapValueUpdate(upd.getValue(), childUpd));
                }
            }
            return ret;
        }

        private List<ValueUpdate> createMapValueUpdatesForStruct(StructuredFieldValue struct, MapValueUpdate upd) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>();
            for (Map.Entry entry : struct) {
                for (ValueUpdate childUpd : this.createValueUpdates((FieldValue)entry.getValue(), upd.getUpdate())) {
                    ret.add((ValueUpdate)new MapValueUpdate((FieldValue)new StringFieldValue(((Field)entry.getKey()).getName()), childUpd));
                }
            }
            return ret;
        }

        private List<ValueUpdate> createMapValueUpdatesForWset(WeightedSet wset, MapValueUpdate upd) {
            ArrayList<ValueUpdate> ret = new ArrayList<ValueUpdate>();
            Iterator it = wset.fieldValueIterator();
            while (it.hasNext()) {
                FieldValue childVal = (FieldValue)it.next();
                for (ValueUpdate childUpd : this.createValueUpdates((FieldValue)new IntegerFieldValue(wset.get((Object)childVal)), upd.getUpdate())) {
                    ret.add((ValueUpdate)new MapValueUpdate(childVal, childUpd));
                }
            }
            return ret;
        }
    }

    private static class CompleteBuilder
    extends PartialBuilder {
        static final ValueUpdate nullAssign = new AssignValueUpdate(null);

        CompleteBuilder() {
            super(null);
        }

        @Override
        List<ValueUpdate> createValueUpdates(FieldValue value, ValueUpdate upd) {
            return super.createValueUpdates(value, nullAssign);
        }
    }
}

