/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.geo.ZCurve;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class ZCurveExpression
extends Expression {
    @Override
    public DataType setInputType(DataType input, VerificationContext context) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof StructDataType)) {
            throw new VerificationException(this, "This requires a struct as input, but got " + input.getName());
        }
        StructDataType struct = (StructDataType)input;
        this.requireIntegerField("x", struct);
        this.requireIntegerField("y", struct);
        super.setInputType(input, context);
        return DataType.LONG;
    }

    private void requireIntegerField(String fieldName, StructDataType struct) {
        Field field = struct.getField(fieldName);
        if (field == null || field.getDataType() != DataType.INT) {
            throw new VerificationException(this, "The struct '" + struct.getName() + "' does not have an integer field named '" + fieldName + "'");
        }
    }

    @Override
    public DataType setOutputType(DataType output, VerificationContext context) {
        super.setOutputType((DataType)DataType.LONG, output, null, context);
        return PositionDataType.INSTANCE;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType(this.createdOutputType());
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        Struct input = (Struct)context.getCurrentValue();
        Integer x = ZCurveExpression.getFieldValue(input, "x");
        Integer y = ZCurveExpression.getFieldValue(input, "y");
        if (x != null && y != null) {
            context.setCurrentValue((FieldValue)new LongFieldValue(ZCurve.encode((int)x, (int)y)));
        } else {
            context.setCurrentValue(DataType.LONG.createFieldValue());
        }
    }

    private static Integer getFieldValue(Struct struct, String fieldName) {
        IntegerFieldValue val = (IntegerFieldValue)struct.getFieldValue(fieldName);
        return val != null ? Integer.valueOf(val.getInteger()) : null;
    }

    @Override
    public DataType createdOutputType() {
        return DataType.LONG;
    }

    public String toString() {
        return "zcurve";
    }

    public boolean equals(Object obj) {
        return obj instanceof ZCurveExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

