/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class ToWsetExpression
extends Expression {
    private final Boolean createIfNonExistent;
    private final Boolean removeIfZero;

    public ToWsetExpression(boolean createIfNonExistent, boolean removeIfZero) {
        this.createIfNonExistent = createIfNonExistent;
        this.removeIfZero = removeIfZero;
    }

    public boolean getCreateIfNonExistent() {
        return this.createIfNonExistent;
    }

    public boolean getRemoveIfZero() {
        return this.removeIfZero;
    }

    @Override
    public DataType setInputType(DataType input, VerificationContext context) {
        super.setInputType(input, context);
        if (input == null) {
            return null;
        }
        return this.outputType(input);
    }

    @Override
    public DataType setOutputType(DataType output, VerificationContext context) {
        if (!(output instanceof WeightedSetDataType)) {
            throw new VerificationException(this, "This creates a WeightedSet, but type " + output.getName() + " is needed");
        }
        super.setOutputType(output, context);
        return this.getInputType(context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        if (context.getCurrentType() != null) {
            context.setCurrentType((DataType)this.outputType(context.getCurrentType()));
        }
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        WeightedSet output = this.outputType(input.getDataType()).createFieldValue();
        output.add(input);
        context.setCurrentValue((FieldValue)output);
    }

    private WeightedSetDataType outputType(DataType inputType) {
        return DataType.getWeightedSet((DataType)inputType, (boolean)this.createIfNonExistent, (boolean)this.removeIfZero);
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "to_wset" + (this.createIfNonExistent != false ? " create_if_non_existent" : "") + (this.removeIfZero != false ? " remove_if_zero" : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ToWsetExpression)) {
            return false;
        }
        ToWsetExpression rhs = (ToWsetExpression)((Object)obj);
        if (this.createIfNonExistent != rhs.createIfNonExistent) {
            return false;
        }
        return this.removeIfZero == rhs.removeIfZero;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.createIfNonExistent.hashCode() + this.removeIfZero.hashCode();
    }
}

