/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.GramSplitter;
import com.yahoo.language.process.TokenType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.linguistics.LinguisticsAnnotator;

public final class NGramExpression
extends Expression {
    private final Linguistics linguistics;
    private final int gramSize;

    public NGramExpression(Linguistics linguistics, int gramSize) {
        this.linguistics = linguistics;
        this.gramSize = gramSize;
    }

    @Override
    public boolean isMutating() {
        return false;
    }

    public Linguistics getLinguistics() {
        return this.linguistics;
    }

    public int getGramSize() {
        return this.gramSize;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        return super.setInputType(inputType, (DataType)DataType.STRING, context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        return super.setOutputType((DataType)DataType.STRING, outputType, null, context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        StringFieldValue input = (StringFieldValue)context.getCurrentValue();
        if (input.getSpanTree("linguistics") != null) {
            return;
        }
        StringFieldValue output = input.clone();
        context.setCurrentValue((FieldValue)output);
        SpanList spanList = output.setSpanTree(new SpanTree("linguistics")).spanList();
        int lastPosition = 0;
        GramSplitter.GramSplitterIterator it = this.linguistics.getGramSplitter().split(output.getString(), this.gramSize);
        while (it.hasNext()) {
            GramSplitter.Gram gram = (GramSplitter.Gram)it.next();
            if (lastPosition < gram.getStart()) {
                this.typedSpan(lastPosition, gram.getStart() - lastPosition, TokenType.PUNCTUATION, spanList);
            }
            String gramString = gram.extractFrom(output.getString());
            this.typedSpan(gram.getStart(), gram.getCodePointCount(), TokenType.ALPHABETIC, spanList).annotate(LinguisticsAnnotator.termAnnotation(LinguisticsCase.toLowerCase((String)gramString), gramString));
            lastPosition = gram.getStart() + gram.getCodePointCount();
        }
        if (lastPosition < output.toString().length()) {
            this.typedSpan(lastPosition, output.toString().length() - lastPosition, TokenType.PUNCTUATION, spanList);
        }
    }

    private Span typedSpan(int from, int length, TokenType tokenType, SpanList spanList) {
        return (Span)spanList.span(from, length).annotate(AnnotationTypes.TOKEN_TYPE, Integer.valueOf(tokenType.getValue()));
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return "ngram " + this.gramSize;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NGramExpression)) {
            return false;
        }
        NGramExpression rhs = (NGramExpression)((Object)obj);
        if (this.linguistics == null) {
            if (rhs.linguistics != null) {
                return false;
            }
        } else if (rhs.linguistics != null) {
            if (this.linguistics.getClass() != rhs.linguistics.getClass()) {
                return false;
            }
        } else {
            return false;
        }
        return this.gramSize == rhs.gramSize;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.gramSize;
    }
}

