/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public class LiteralBoolExpression
extends Expression {
    private final boolean value;

    public LiteralBoolExpression(boolean value) {
        this.value = value;
    }

    @Override
    public boolean requiresInput() {
        return false;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        return DataType.BOOL;
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType((DataType)DataType.BOOL, outputType, null, context);
        return AnyDataType.instance;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType(this.createdOutputType());
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setCurrentValue((FieldValue)new BoolFieldValue(this.value));
    }

    @Override
    public DataType createdOutputType() {
        return DataType.BOOL;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LiteralBoolExpression)) {
            return false;
        }
        return ((LiteralBoolExpression)((Object)other)).value == this.value;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }
}

