/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.filedistribution.fileacquirer;

import com.yahoo.filedistribution.fileacquirer.TimeoutException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

class Timer {
    private final long endTime;

    private Duration timeLeft() {
        return Duration.ofNanos(this.endTime - System.nanoTime());
    }

    public Timer(long timeout, TimeUnit timeUnit) {
        this.endTime = System.nanoTime() + timeUnit.toNanos(timeout);
    }

    public long timeLeft(TimeUnit timeUnit) {
        long remaining = timeUnit.convert(this.timeLeft().toMillis(), TimeUnit.MILLISECONDS);
        if (remaining > 0L) {
            return remaining;
        }
        throw new TimeoutException("Timed out");
    }

    public boolean isTimeLeft() {
        return !this.timeLeft().isNegative();
    }
}

