/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentapi.messagebus.protocol;

import com.yahoo.document.BucketId;
import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.DocumentReply;
import com.yahoo.documentapi.messagebus.protocol.StatBucketReply;

public class StatBucketMessage
extends DocumentMessage {
    private BucketId bucketId;
    private String bucketSpace = FixedBucketSpaces.defaultSpace();
    private String documentSelection;

    StatBucketMessage() {
    }

    public StatBucketMessage(BucketId bucket, String documentSelection) {
        this(bucket, FixedBucketSpaces.defaultSpace(), documentSelection);
    }

    public StatBucketMessage(BucketId bucketId, String bucketSpace, String documentSelection) {
        this.bucketId = bucketId;
        this.bucketSpace = bucketSpace;
        this.documentSelection = documentSelection;
    }

    public BucketId getBucketId() {
        return this.bucketId;
    }

    void setBucketId(BucketId bucket) {
        this.bucketId = bucket;
    }

    public String getDocumentSelection() {
        return this.documentSelection;
    }

    void setDocumentSelection(String documentSelection) {
        this.documentSelection = documentSelection;
    }

    public String getBucketSpace() {
        return this.bucketSpace;
    }

    public void setBucketSpace(String bucketSpace) {
        this.bucketSpace = bucketSpace;
    }

    @Override
    public DocumentReply createReply() {
        return new StatBucketReply();
    }

    @Override
    public int getApproxSize() {
        return super.getApproxSize() + 8 + this.bucketSpace.length() + this.documentSelection.length();
    }

    public int getType() {
        return 100019;
    }
}

