/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespaxmlparser;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.MapDataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.fieldpathupdate.AddFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.AssignFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.fieldpathupdate.RemoveFieldPathUpdate;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.document.serialization.DocumentUpdateReader;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.vespaxmlparser.VespaXMLFieldReader;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class VespaXMLUpdateReader
extends VespaXMLFieldReader
implements DocumentUpdateReader {
    private Optional<String> condition = Optional.empty();

    public VespaXMLUpdateReader(String fileName, DocumentTypeManager docTypeManager) throws Exception {
        super(fileName, docTypeManager);
    }

    public VespaXMLUpdateReader(InputStream stream, DocumentTypeManager docTypeManager) throws Exception {
        super(stream, docTypeManager);
    }

    public VespaXMLUpdateReader(XMLStreamReader reader, DocumentTypeManager docTypeManager) {
        super(reader, docTypeManager);
    }

    @Override
    public Optional<String> getCondition() {
        return this.condition;
    }

    public boolean hasFieldPath() {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!this.reader.getAttributeName(i).toString().equals("fieldpath")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void read(DocumentUpdate update) {
        try {
            DocumentType doctype = null;
            for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                String attributeName = this.reader.getAttributeName(i).toString();
                String attributeValue = this.reader.getAttributeValue(i);
                if ("documentid".equals(attributeName) || "id".equals(attributeName)) {
                    update.setId(new DocumentId(attributeValue));
                    continue;
                }
                if ("documenttype".equals(attributeName) || "type".equals(attributeName)) {
                    doctype = this.docTypeManager.getDocumentType(attributeValue);
                    update.setDocumentType(doctype);
                    continue;
                }
                if ("create-if-non-existent".equals(attributeName)) {
                    if ("true".equals(attributeValue)) {
                        update.setCreateIfNonExistent(true);
                        continue;
                    }
                    if ("false".equals(attributeValue)) {
                        update.setCreateIfNonExistent(false);
                        continue;
                    }
                    throw this.newDeserializeException("'create-if-non-existent' must be either 'true' or 'false', was '" + attributeValue + "'");
                }
                if (!"condition".equals(attributeName)) continue;
                this.condition = Optional.of(attributeValue);
            }
            if (doctype == null) {
                throw this.newDeserializeException("Must specify document type. " + String.valueOf(this.reader.getLocation()));
            }
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                if (type == 1) {
                    String currentName = this.reader.getName().toString();
                    if (this.hasFieldPath()) {
                        if ("assign".equals(currentName)) {
                            update.addFieldPathUpdate(new AssignFieldPathUpdate(doctype, this));
                            this.skipToEnd("assign");
                            continue;
                        }
                        if ("add".equals(currentName)) {
                            update.addFieldPathUpdate(new AddFieldPathUpdate(doctype, this));
                            this.skipToEnd("add");
                            continue;
                        }
                        if ("remove".equals(currentName)) {
                            update.addFieldPathUpdate(new RemoveFieldPathUpdate(doctype, this));
                            this.skipToEnd("remove");
                            continue;
                        }
                        throw this.newDeserializeException("Unknown field path update operation " + String.valueOf(this.reader.getName()));
                    }
                    if ("assign".equals(currentName)) {
                        update.addFieldUpdate(this.readAssign(update));
                        this.skipToEnd("assign");
                        continue;
                    }
                    if ("add".equals(currentName)) {
                        update.addFieldUpdate(this.readAdd(update));
                        this.skipToEnd("add");
                        continue;
                    }
                    if ("remove".equals(currentName)) {
                        update.addFieldUpdate(this.readRemove(update));
                        this.skipToEnd("remove");
                        continue;
                    }
                    if ("alter".equals(currentName)) {
                        update.addFieldUpdate(this.readAlter(update));
                        this.skipToEnd("alter");
                        continue;
                    }
                    if ("increment".equals(currentName) || "decrement".equals(currentName) || "multiply".equals(currentName) || "divide".equals(currentName)) {
                        update.addFieldUpdate(this.readArithmeticField(update, currentName));
                        this.skipToEnd(currentName);
                        continue;
                    }
                    throw this.newDeserializeException("Unknown update operation " + String.valueOf(this.reader.getName()));
                }
                if (type != 2) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(e);
        }
    }

    FieldUpdate readAdd(DocumentUpdate update) throws XMLStreamException {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"field".equals(this.reader.getAttributeName(i).toString())) continue;
            Field f = update.getDocumentType().getField(this.reader.getAttributeValue(i));
            FieldValue value = f.getDataType().createFieldValue();
            value.deserialize(f, this);
            if (value instanceof Array) {
                List l = ((Array)value).getValues();
                return FieldUpdate.createAddAll(f, l);
            }
            if (value instanceof WeightedSet) {
                return FieldUpdate.createAddAll(f, (WeightedSet)value);
            }
            throw this.newDeserializeException("Add operation only applicable to multivalue lists");
        }
        throw this.newDeserializeException("Add update without field attribute");
    }

    FieldUpdate readRemove(DocumentUpdate update) throws XMLStreamException {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"field".equals(this.reader.getAttributeName(i).toString())) continue;
            Field f = update.getDocumentType().getField(this.reader.getAttributeValue(i));
            FieldValue value = f.getDataType().createFieldValue();
            value.deserialize(f, this);
            if (value instanceof Array) {
                List l = ((Array)value).getValues();
                return FieldUpdate.createRemoveAll(f, l);
            }
            if (value instanceof WeightedSet) {
                return FieldUpdate.createRemoveAll(f, (WeightedSet)value);
            }
            throw this.newDeserializeException("Remove operation only applicable to multivalue lists");
        }
        throw this.newDeserializeException("Remove update without field attribute");
    }

    FieldUpdate readAssign(DocumentUpdate update) throws XMLStreamException {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"field".equals(this.reader.getAttributeName(i).toString())) continue;
            Field f = update.getDocumentType().getField(this.reader.getAttributeValue(i));
            if (f == null) {
                throw this.newDeserializeException("Field " + this.reader.getAttributeValue(i) + " not found.");
            }
            FieldValue value = f.getDataType().createFieldValue();
            value.deserialize(f, this);
            return FieldUpdate.createAssign(f, value);
        }
        throw this.newDeserializeException("Assignment update without field attribute");
    }

    FieldUpdate readAlter(DocumentUpdate update) throws XMLStreamException {
        Field f = null;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"field".equals(this.reader.getAttributeName(i).toString())) continue;
            f = update.getDocumentType().getField(this.reader.getAttributeValue(i));
        }
        if (f == null) {
            throw this.newDeserializeException("Alter update without \"field\" attribute");
        }
        FieldUpdate fu = FieldUpdate.create(f);
        while (this.reader.hasNext()) {
            int type = this.reader.next();
            if (type == 1) {
                if ("increment".equals(this.reader.getName().toString()) || "decrement".equals(this.reader.getName().toString()) || "multiply".equals(this.reader.getName().toString()) || "divide".equals(this.reader.getName().toString())) {
                    update.addFieldUpdate(this.readArithmetic(update, this.reader.getName().toString(), f, fu));
                    this.skipToEnd(this.reader.getName().toString());
                    continue;
                }
                throw this.newDeserializeException("Element \"" + String.valueOf(this.reader.getName()) + "\" not appropriate within alter element");
            }
            if (type != 2) continue;
            break;
        }
        return fu;
    }

    FieldUpdate readArithmeticField(DocumentUpdate update, String type) throws XMLStreamException {
        Field f = null;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"field".equals(this.reader.getAttributeName(i).toString())) continue;
            f = update.getDocumentType().getField(this.reader.getAttributeValue(i));
        }
        if (f == null) {
            throw this.newDeserializeException("Assignment update without \"field\" attribute");
        }
        FieldUpdate fu = FieldUpdate.create(f);
        this.readArithmetic(update, type, f, fu);
        return fu;
    }

    FieldUpdate readArithmetic(DocumentUpdate update, String type, Field f, FieldUpdate fu) throws XMLStreamException {
        Double by = null;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"by".equals(this.reader.getAttributeName(i).toString())) continue;
            by = Double.parseDouble(this.reader.getAttributeValue(i));
        }
        if (by == null) {
            throw this.newDeserializeException("Assignment update without \"by\" attribute");
        }
        FieldValue key = null;
        do {
            this.reader.next();
            if (this.reader.getEventType() != 1) continue;
            if ("key".equals(this.reader.getName().toString())) {
                if (f.getDataType() instanceof WeightedSetDataType) {
                    DataType nestedType = ((WeightedSetDataType)f.getDataType()).getNestedType();
                    key = nestedType.createFieldValue();
                    key.deserialize(this);
                } else if (f.getDataType() instanceof MapDataType) {
                    key = ((MapDataType)f.getDataType()).getKeyType().createFieldValue();
                    key.deserialize(this);
                } else if (f.getDataType() instanceof ArrayDataType) {
                    key = new IntegerFieldValue(Integer.parseInt(this.reader.getElementText()));
                } else {
                    throw this.newDeserializeException("Key tag only applicable for weighted sets and maps");
                }
                this.skipToEnd("key");
                continue;
            }
            throw this.newDeserializeException("\"" + String.valueOf(this.reader.getName()) + "\" not appropriate within " + type + " element.");
        } while (this.reader.getEventType() != 2);
        if (key != null) {
            if ("increment".equals(type)) {
                fu.addValueUpdate(ValueUpdate.createIncrement(key, by));
            }
            if ("decrement".equals(type)) {
                fu.addValueUpdate(ValueUpdate.createDecrement(key, by));
            }
            if ("multiply".equals(type)) {
                fu.addValueUpdate(ValueUpdate.createMultiply(key, by));
            }
            if ("divide".equals(type)) {
                fu.addValueUpdate(ValueUpdate.createDivide(key, by));
            }
        } else {
            if ("increment".equals(type)) {
                fu.addValueUpdate(ValueUpdate.createIncrement(by));
            }
            if ("decrement".equals(type)) {
                fu.addValueUpdate(ValueUpdate.createDecrement(by));
            }
            if ("multiply".equals(type)) {
                fu.addValueUpdate(ValueUpdate.createMultiply(by));
            }
            if ("divide".equals(type)) {
                fu.addValueUpdate(ValueUpdate.createDivide(by));
            }
        }
        return fu;
    }

    @Override
    public void read(FieldUpdate update) {
    }

    @Override
    public void read(FieldPathUpdate update) {
        String whereClause = null;
        String fieldPath = null;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (this.reader.getAttributeName(i).toString().equals("where")) {
                whereClause = this.reader.getAttributeValue(i);
                continue;
            }
            if (!this.reader.getAttributeName(i).toString().equals("fieldpath")) continue;
            fieldPath = this.reader.getAttributeValue(i);
        }
        if (fieldPath == null) {
            throw this.newDeserializeException("Field path is required for document updates.");
        }
        update.setFieldPath(fieldPath);
        if (whereClause != null) {
            try {
                update.setWhereClause(whereClause);
            }
            catch (ParseException e) {
                throw this.newException(e);
            }
        }
    }

    @Override
    public void read(AssignFieldPathUpdate update) {
        try {
            for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                if (this.reader.getAttributeName(i).toString().equals("removeifzero")) {
                    update.setRemoveIfZero(Boolean.parseBoolean(this.reader.getAttributeValue(i)));
                    continue;
                }
                if (!this.reader.getAttributeName(i).toString().equals("createmissingpath")) continue;
                update.setCreateMissingPath(Boolean.parseBoolean(this.reader.getAttributeValue(i)));
            }
            DataType dt = update.getFieldPath().getResultingDataType();
            if (dt instanceof NumericDataType) {
                update.setExpression(this.reader.getElementText());
            } else {
                FieldValue fv = dt.createFieldValue();
                fv.deserialize(VespaXMLUpdateReader.resolveField(update), this);
                update.setNewValue(fv);
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(e);
        }
    }

    @Override
    public void read(AddFieldPathUpdate update) {
        DataType dt = update.getFieldPath().getResultingDataType();
        FieldValue fv = dt.createFieldValue();
        fv.deserialize(VespaXMLUpdateReader.resolveField(update), this);
        update.setNewValues((Array)fv);
    }

    @Override
    public void read(RemoveFieldPathUpdate update) {
    }

    private static Field resolveField(FieldPathUpdate update) {
        String orig = update.getOriginalFieldPath();
        if (orig == null) {
            return null;
        }
        FieldPath path = update.getFieldPath();
        if (path == null) {
            return null;
        }
        DataType type = path.getResultingDataType();
        if (type == null) {
            return null;
        }
        return new Field(orig, type);
    }
}

