/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.serialization;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AlternateSpanList;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationReference;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.ReferenceFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.fieldpathupdate.AddFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.AssignFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.fieldpathupdate.RemoveFieldPathUpdate;
import com.yahoo.document.predicate.BinaryFormat;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.document.serialization.DeserializationException;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.DocumentUpdateFlags;
import com.yahoo.document.serialization.SerializationException;
import com.yahoo.document.update.AddValueUpdate;
import com.yahoo.document.update.ArithmeticValueUpdate;
import com.yahoo.document.update.AssignValueUpdate;
import com.yahoo.document.update.ClearValueUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.RemoveValueUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.FieldBase;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Deprecated(forRemoval=true)
public class VespaDocumentDeserializer6
extends BufferSerializer
implements DocumentDeserializer {
    private final DocumentTypeManager manager;
    private short version;
    private List<SpanNode> spanNodes;
    private List<Annotation> annotations;
    private int[] stringPositions;

    VespaDocumentDeserializer6(DocumentTypeManager manager, GrowableByteBuffer buf) {
        super(buf);
        this.manager = manager;
        this.version = (short)8;
    }

    @Override
    public DocumentTypeManager getTypeRepo() {
        return this.manager;
    }

    @Override
    public void read(Document document) {
        this.read(null, document);
    }

    @Override
    public void read(FieldBase field, Document doc) {
        this.version = this.getShort(null);
        if (this.version < 8 || this.version > 8) {
            throw new DeserializationException("Unknown version " + this.version + ", expected 8.");
        }
        int dataLength = this.getInt(null);
        int dataPos = this.position();
        DocumentId documentId = this.readDocumentId();
        byte content = this.getByte(null);
        doc.setDataType(this.readDocumentType());
        doc.setId(documentId);
        if ((content & 2) != 0) {
            this.readStruct(doc, doc.getDataType().contentStruct());
        }
        if ((content & 4) != 0) {
            this.readStruct(doc, doc.getDataType().contentStruct());
        }
        if (dataLength != this.position() - dataPos) {
            throw new DeserializationException("Length mismatch");
        }
    }

    @Override
    public void read(FieldBase field, FieldValue value) {
        throw new IllegalArgumentException("read not implemented yet.");
    }

    @Override
    public <T extends FieldValue> void read(FieldBase field, Array<T> array) {
        int numElements = this.getNumCollectionElems();
        ArrayList<FieldValue> list = new ArrayList<FieldValue>(numElements);
        ArrayDataType type = array.getDataType();
        for (int i = 0; i < numElements; ++i) {
            FieldValue fv = type.getNestedType().createFieldValue();
            fv.deserialize(null, this);
            list.add(fv);
        }
        array.clear();
        array.addAll(list);
    }

    @Override
    public <K extends FieldValue, V extends FieldValue> void read(FieldBase field, MapFieldValue<K, V> map) {
        int numElements = this.getNumCollectionElems();
        HashMap<FieldValue, FieldValue> hash = new HashMap<FieldValue, FieldValue>();
        MapDataType type = map.getDataType();
        for (int i = 0; i < numElements; ++i) {
            FieldValue key = type.getKeyType().createFieldValue();
            FieldValue val = type.getValueType().createFieldValue();
            key.deserialize(null, this);
            val.deserialize(null, this);
            hash.put(key, val);
        }
        map.clear();
        map.putAll(hash);
    }

    private int getNumCollectionElems() {
        int numElements = this.getInt1_2_4Bytes(null);
        if (numElements < 0) {
            throw new DeserializationException("Bad number of array/map elements, " + numElements);
        }
        return numElements;
    }

    @Override
    public <T extends FieldValue> void read(FieldBase field, CollectionFieldValue<T> value) {
        throw new IllegalArgumentException("read not implemented yet.");
    }

    @Override
    public void read(FieldBase field, ByteFieldValue value) {
        value.assign(this.getByte(null));
    }

    @Override
    public void read(FieldBase field, BoolFieldValue value) {
        value.setBoolean(this.getByte(null) != 0);
    }

    @Override
    public void read(FieldBase field, DoubleFieldValue value) {
        value.assign(this.getDouble(null));
    }

    @Override
    public void read(FieldBase field, FloatFieldValue value) {
        value.assign(Float.valueOf(this.getFloat(null)));
    }

    @Override
    public void read(FieldBase field, IntegerFieldValue value) {
        value.assign(this.getInt(null));
    }

    @Override
    public void read(FieldBase field, LongFieldValue value) {
        value.assign(this.getLong(null));
    }

    @Override
    public void read(FieldBase field, Raw value) {
        int rawsize = this.getInt(null);
        byte[] rawBytes = this.getBytes(null, rawsize);
        value.assign(rawBytes);
    }

    @Override
    public void read(FieldBase field, PredicateFieldValue value) {
        int len = this.getInt(null);
        byte[] buf = this.getBytes(null, len);
        value.assign(BinaryFormat.decode((byte[])buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(FieldBase field, StringFieldValue value) {
        byte coding = this.getByte(null);
        int length = this.getInt1_4Bytes(null);
        byte[] stringArray = new byte[length - 1];
        this.buf.get(stringArray);
        this.buf.get();
        value.setUnChecked(Utf8.toString((byte[])stringArray));
        if ((coding & 0x40) == 64) {
            try {
                this.stringPositions = Utf8.calculateStringPositions((byte[])stringArray);
                int size = this.buf.getInt();
                int startPos = this.buf.position();
                int numSpanTrees = this.buf.getInt1_2_4Bytes();
                for (int i = 0; i < numSpanTrees; ++i) {
                    SpanTree tree = new SpanTree();
                    StringFieldValue treeName = new StringFieldValue();
                    treeName.deserialize(this);
                    tree.setName(treeName.getString());
                    value.setSpanTree(tree);
                    this.readSpanTree(tree, false);
                }
                this.buf.position(startPos + size);
            }
            finally {
                this.stringPositions = null;
            }
        }
    }

    @Override
    public void read(FieldBase field, TensorFieldValue value) {
        int encodedTensorLength = this.buf.getInt1_4Bytes();
        if (encodedTensorLength > 0) {
            byte[] encodedTensor = this.getBytes(null, encodedTensorLength);
            value.assignSerializedTensor(encodedTensor);
        } else {
            value.clear();
        }
    }

    @Override
    public void read(FieldBase field, ReferenceFieldValue value) {
        boolean documentIdPresent;
        boolean bl = documentIdPresent = this.buf.get() != 0;
        if (documentIdPresent) {
            value.assign((Object)this.readDocumentId());
        } else {
            value.clear();
        }
    }

    @Override
    public void read(FieldBase fieldDef, Struct s) {
        s.setVersion(this.version);
        s.clear();
        this.readStruct(s, s.getDataType());
    }

    private void readStruct(StructuredFieldValue target, StructDataType priType) {
        if (this.version < 8) {
            throw new DeserializationException("Illegal document serialization version " + this.version);
        }
        int dataSize = this.getInt(null);
        byte unusedComprCode = this.getByte(null);
        int numberOfFields = this.getInt1_4Bytes(null);
        int[] fieldIds = new int[numberOfFields];
        int[] fieldLens = new int[numberOfFields];
        for (int i = 0; i < numberOfFields; ++i) {
            fieldIds[i] = this.getInt1_4Bytes(null);
            fieldLens[i] = (int)this.getInt2_4_8Bytes(null);
        }
        int afterPos = this.position() + dataSize;
        for (int i = 0; i < numberOfFields; ++i) {
            int posBefore = this.position();
            Field structField = priType.getField(fieldIds[i]);
            if (structField != null) {
                FieldValue value = structField.getDataType().createFieldValue();
                value.deserialize(structField, this);
                target.setFieldValue(structField, value);
            }
            this.position(posBefore + fieldLens[i]);
        }
        this.position(afterPos);
    }

    @Override
    public void read(FieldBase field, StructuredFieldValue value) {
        throw new IllegalArgumentException("read not implemented yet.");
    }

    @Override
    public <T extends FieldValue> void read(FieldBase field, WeightedSet<T> ws) {
        WeightedSetDataType type = ws.getDataType();
        this.getInt(null);
        int numElements = this.getInt(null);
        if (numElements < 0) {
            throw new DeserializationException("Bad number of weighted set elements, " + numElements);
        }
        ws.clearAndReserve(numElements * 2);
        for (int i = 0; i < numElements; ++i) {
            int unusedSize = this.getInt(null);
            FieldValue value = type.getNestedType().createFieldValue();
            value.deserialize(null, this);
            IntegerFieldValue weight = new IntegerFieldValue(this.getInt(null));
            ws.putUnChecked(value, weight);
        }
    }

    @Override
    public void read(FieldBase field, AnnotationReference value) {
        int seqId = this.buf.getInt1_2_4Bytes();
        try {
            Annotation a = this.annotations.get(seqId);
            value.setReferenceNoCompatibilityCheck(a);
        }
        catch (IndexOutOfBoundsException iiobe) {
            throw new SerializationException("Could not serialize AnnotationReference value, reference not found.", iiobe);
        }
    }

    private Utf8Array parseNullTerminatedString() {
        return VespaDocumentDeserializer6.parseNullTerminatedString(this.getBuf().getByteBuffer());
    }

    static Utf8Array parseNullTerminatedString(ByteBuffer buf, int lengthExcludingNull) throws DeserializationException {
        Utf8Array utf8 = new Utf8Array(buf, lengthExcludingNull);
        buf.get();
        return utf8;
    }

    static Utf8Array parseNullTerminatedString(ByteBuffer buf) throws DeserializationException {
        int end = VespaDocumentDeserializer6.getFirstNullByte(buf);
        if (end == -1) {
            throw new DeserializationException("Could not locate terminating 0-byte for string");
        }
        return VespaDocumentDeserializer6.parseNullTerminatedString(buf, end - buf.position());
    }

    private static int getFirstNullByte(ByteBuffer buf) {
        int end = -1;
        int start = buf.position();
        try {
            byte dataByte;
            while ((dataByte = buf.get()) != 0) {
            }
            end = buf.position() - 1;
        }
        catch (Exception e) {
            // empty catch block
        }
        buf.position(start);
        return end;
    }

    @Override
    public void read(DocumentUpdate update) {
        update.setId(new DocumentId(this));
        update.setDocumentType(this.readDocumentType());
        int size = this.getInt(null);
        for (int i = 0; i < size; ++i) {
            update.addFieldUpdate(new FieldUpdate(this, update.getDocumentType()));
        }
        int sizeAndFlags = this.getInt(null);
        update.setCreateIfNonExistent(DocumentUpdateFlags.extractFlags(sizeAndFlags).getCreateIfNonExistent());
        size = DocumentUpdateFlags.extractValue(sizeAndFlags);
        for (int i = 0; i < size; ++i) {
            byte type = this.getByte(null);
            update.addFieldPathUpdate(FieldPathUpdate.create(FieldPathUpdate.Type.valueOf(type), update.getDocumentType(), this));
        }
    }

    @Override
    public void read(FieldPathUpdate update) {
        String fieldPath = this.getString(null);
        String whereClause = this.getString(null);
        update.setFieldPath(fieldPath);
        try {
            update.setWhereClause(whereClause);
        }
        catch (ParseException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void read(AssignFieldPathUpdate update) {
        byte flags = this.getByte(null);
        update.setRemoveIfZero((flags & 2) != 0);
        update.setCreateMissingPath((flags & 4) != 0);
        if ((flags & 1) != 0) {
            update.setExpression(this.getString(null));
        } else {
            DataType dt = update.getFieldPath().getResultingDataType();
            FieldValue fv = dt.createFieldValue();
            fv.deserialize(this);
            update.setNewValue(fv);
        }
    }

    @Override
    public void read(RemoveFieldPathUpdate update) {
    }

    @Override
    public void read(AddFieldPathUpdate update) {
        DataType dt = update.getFieldPath().getResultingDataType();
        FieldValue fv = dt.createFieldValue();
        dt.createFieldValue();
        fv.deserialize(this);
        if (!(fv instanceof Array)) {
            throw new DeserializationException("Add only applicable to array types");
        }
        update.setNewValues((Array)fv);
    }

    private ValueUpdate getValueUpdate(DataType superType, DataType subType) {
        int vuTypeId = this.getInt(null);
        ValueUpdate.ValueUpdateClassID op = ValueUpdate.ValueUpdateClassID.getID(vuTypeId);
        if (op == null) {
            throw new IllegalArgumentException("Read type " + vuTypeId + " of bytebuffer, but this is not a legal value update type.");
        }
        switch (op) {
            case ADD: {
                FieldValue fval = subType.createFieldValue();
                fval.deserialize(this);
                int weight = this.getInt(null);
                return new AddValueUpdate(fval, weight);
            }
            case ARITHMETIC: {
                int opId = this.getInt(null);
                ArithmeticValueUpdate.Operator operator = ArithmeticValueUpdate.Operator.getID(opId);
                double operand = this.getDouble(null);
                return new ArithmeticValueUpdate(operator, operand);
            }
            case ASSIGN: {
                byte contents = this.getByte(null);
                FieldValue fval = null;
                if (contents == 1) {
                    fval = superType.createFieldValue();
                    fval.deserialize(this);
                }
                return new AssignValueUpdate(fval);
            }
            case CLEAR: {
                return new ClearValueUpdate();
            }
            case MAP: {
                if (superType instanceof ArrayDataType) {
                    CollectionDataType type = (CollectionDataType)superType;
                    IntegerFieldValue index = new IntegerFieldValue();
                    index.deserialize(this);
                    ValueUpdate update = this.getValueUpdate(type.getNestedType(), null);
                    return new MapValueUpdate(index, update);
                }
                if (superType instanceof WeightedSetDataType) {
                    CollectionDataType type = (CollectionDataType)superType;
                    FieldValue fval = type.getNestedType().createFieldValue();
                    fval.deserialize(this);
                    ValueUpdate update = this.getValueUpdate(DataType.INT, null);
                    return new MapValueUpdate(fval, update);
                }
                throw new DeserializationException("MapValueUpdate only works for arrays and weighted sets");
            }
            case REMOVE: {
                FieldValue fval = ((CollectionDataType)superType).getNestedType().createFieldValue();
                fval.deserialize(this);
                return new RemoveValueUpdate(fval);
            }
            case TENSORMODIFY: {
                return this.readTensorModifyUpdate(superType);
            }
            case TENSORADD: {
                return this.readTensorAddUpdate(superType);
            }
            case TENSORREMOVE: {
                return this.readTensorRemoveUpdate(superType);
            }
        }
        throw new DeserializationException("Could not deserialize ValueUpdate, unknown valueUpdateClassID type " + vuTypeId);
    }

    @Override
    public void read(FieldUpdate fieldUpdate) {
        int fieldId = this.getInt(null);
        Field field = fieldUpdate.getDocumentType().getField(fieldId);
        if (field == null) {
            throw new DeserializationException("Cannot deserialize FieldUpdate: Field fieldId " + fieldId + " not found in " + String.valueOf(fieldUpdate.getDocumentType()));
        }
        fieldUpdate.setField(field);
        int size = this.getInt(null);
        for (int i = 0; i < size; ++i) {
            DataType dataType = field.getDataType();
            if (dataType instanceof CollectionDataType) {
                CollectionDataType collType = (CollectionDataType)dataType;
                fieldUpdate.addValueUpdate(this.getValueUpdate(collType, collType.getNestedType()));
                continue;
            }
            fieldUpdate.addValueUpdate(this.getValueUpdate(field.getDataType(), null));
        }
    }

    @Override
    public DocumentId readDocumentId() {
        Utf8String uri = new Utf8String((AbstractUtf8Array)VespaDocumentDeserializer6.parseNullTerminatedString(this.getBuf().getByteBuffer()));
        return DocumentId.createFromSerialized(uri.toString());
    }

    @Override
    public DocumentType readDocumentType() {
        Utf8Array docTypeName = this.parseNullTerminatedString();
        short ignoredVersion = this.getShort(null);
        DocumentType docType = this.manager.getDocumentType(new DataTypeName(docTypeName));
        if (docType == null) {
            throw new DeserializationException("No known document type with name " + String.valueOf(new Utf8String((AbstractUtf8Array)docTypeName)));
        }
        return docType;
    }

    private SpanNode readSpanNode() {
        SpanNode retval;
        byte type = this.buf.get();
        this.buf.position(this.buf.position() - 1);
        if (type == 1) {
            retval = new Span();
            if (this.spanNodes != null) {
                this.spanNodes.add(retval);
            }
            this.read((Span)retval);
        } else if (type == 2) {
            retval = new SpanList();
            if (this.spanNodes != null) {
                this.spanNodes.add(retval);
            }
            this.read((SpanList)retval);
        } else if (type == 4) {
            retval = new AlternateSpanList();
            if (this.spanNodes != null) {
                this.spanNodes.add(retval);
            }
            this.read((AlternateSpanList)retval);
        } else {
            throw new DeserializationException("Cannot read SpanNode of type " + type);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSpanTree(SpanTree tree, boolean readName) {
        if (this.spanNodes != null || this.annotations != null) {
            throw new SerializationException("Deserialization of nested SpanTrees is not supported.");
        }
        this.spanNodes = new ArrayList<SpanNode>();
        this.annotations = new ArrayList<Annotation>();
        try {
            int i;
            if (readName) {
                StringFieldValue treeName = new StringFieldValue();
                treeName.deserialize(this);
                tree.setName(treeName.getString());
            }
            SpanNode root = this.readSpanNode();
            tree.setRoot(root);
            int numAnnotations = this.buf.getInt1_2_4Bytes();
            for (i = 0; i < numAnnotations; ++i) {
                Annotation a = new Annotation();
                this.annotations.add(a);
            }
            for (i = 0; i < numAnnotations; ++i) {
                this.read(this.annotations.get(i));
            }
            for (Annotation a : this.annotations) {
                tree.annotate(a);
            }
            for (SpanNode node : this.spanNodes) {
                if (!(node instanceof Span)) continue;
                this.correctIndexes((Span)node);
            }
        }
        finally {
            this.spanNodes = null;
            this.annotations = null;
        }
    }

    @Override
    public void read(SpanTree tree) {
        this.readSpanTree(tree, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Annotation annotation) {
        int annotationTypeId = this.buf.getInt();
        AnnotationType type = this.manager.getAnnotationTypeRegistry().getType(annotationTypeId);
        if (type == null) {
            throw new DeserializationException("Cannot deserialize annotation of type " + annotationTypeId + " (unknown type)");
        }
        annotation.setType(type);
        byte features = this.buf.get();
        int length = this.buf.getInt1_2_4Bytes();
        int skipToPos = this.buf.position() + length;
        if ((features & 1) == 1) {
            int spanNodeId = this.buf.getInt1_2_4Bytes();
            try {
                SpanNode node = this.spanNodes.get(spanNodeId);
                annotation.setSpanNode(node);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new DeserializationException("Could not deserialize annotation, associated span node not found ", ioobe);
            }
        }
        if ((features & 2) == 2) {
            int dataTypeId = this.buf.getInt();
            try {
                FieldValue value = type.getDataType().createFieldValue();
                value.deserialize(this);
                annotation.setFieldValue(value);
            }
            catch (RuntimeException rte) {
                if (dataTypeId == type.getDataType().getId()) {
                    throw new DeserializationException("Could not deserialize annotation payload", rte);
                }
            }
            finally {
                this.buf.position(skipToPos);
            }
        }
    }

    @Override
    public void read(Span span) {
        byte type = this.buf.get();
        if (type != 1) {
            throw new DeserializationException("Cannot deserialize Span with type " + type);
        }
        span.setFrom(this.buf.getInt1_2_4Bytes());
        span.setLength(this.buf.getInt1_2_4Bytes());
    }

    private void correctIndexes(Span span) {
        if (this.stringPositions == null) {
            throw new DeserializationException("Cannot deserialize Span, no access to parent StringFieldValue.");
        }
        int fromIndex = this.stringPositions[span.getFrom()];
        int toIndex = this.stringPositions[span.getTo()];
        int length = toIndex - fromIndex;
        span.setFrom(fromIndex);
        span.setLength(length);
    }

    @Override
    public void read(SpanList spanList) {
        byte type = this.buf.get();
        if (type != 2) {
            throw new DeserializationException("Cannot deserialize SpanList with type " + type);
        }
        List<SpanNode> nodes = this.readSpanList();
        for (SpanNode node : nodes) {
            spanList.add(node);
        }
    }

    @Override
    public void read(AlternateSpanList altSpanList) {
        byte type = this.buf.get();
        if (type != 4) {
            throw new DeserializationException("Cannot deserialize AlternateSpanList with type " + type);
        }
        int numSubTrees = this.buf.getInt1_2_4Bytes();
        for (int i = 0; i < numSubTrees; ++i) {
            double prob = this.buf.getDouble();
            List<SpanNode> list = this.readSpanList();
            if (i == 0) {
                for (SpanNode node : list) {
                    altSpanList.add(node);
                }
                altSpanList.setProbability(0, prob);
                continue;
            }
            altSpanList.addChildren(i, list, prob);
        }
    }

    private List<SpanNode> readSpanList() {
        int size = this.buf.getInt1_2_4Bytes();
        ArrayList<SpanNode> spanList = new ArrayList<SpanNode>();
        for (int i = 0; i < size; ++i) {
            spanList.add(this.readSpanNode());
        }
        return spanList;
    }

    protected ValueUpdate readTensorModifyUpdate(DataType type) {
        throw new DeserializationException("Cannot deserialize TensorModifyUpdate, not implemented for this document format version");
    }

    protected ValueUpdate readTensorAddUpdate(DataType type) {
        throw new DeserializationException("Cannot deserialize TensorAddUpdate, not implemented for this document format version");
    }

    protected ValueUpdate readTensorRemoveUpdate(DataType type) {
        throw new DeserializationException("Cannot deserialize TensorRemoveUpdate, not implemented for this document format version");
    }
}

