/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.yahoo.document.DocumentId;
import com.yahoo.document.Field;

public class JsonReaderException
extends IllegalArgumentException {
    public final DocumentId docId;
    public final Field field;
    public final Throwable cause;

    public JsonReaderException(DocumentId docId, Field field, Throwable cause) {
        super("In document '" + String.valueOf((Object)docId) + "': Could not parse " + String.valueOf(field), cause);
        this.docId = docId;
        this.field = field;
        this.cause = cause;
    }

    public JsonReaderException(Field field, Throwable cause) {
        this(null, field, cause);
    }

    public static JsonReaderException addDocId(JsonReaderException oldException, DocumentId docId) {
        return new JsonReaderException(docId, oldException.field, oldException.cause);
    }

    public DocumentId getDocId() {
        return this.docId;
    }

    public Field getField() {
        return this.field;
    }
}

