/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.SpanNodeParent;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import java.util.ListIterator;

public abstract class SpanNode
implements Comparable<SpanNode>,
SpanNodeParent {
    private boolean valid = true;
    private int scratchId = -1;
    private SpanNodeParent parent;

    protected SpanNode() {
    }

    public boolean isValid() {
        return this.valid;
    }

    void setInvalid() {
        this.valid = false;
    }

    public void setScratchId(int id) {
        this.scratchId = id;
    }

    public int getScratchId() {
        return this.scratchId;
    }

    public SpanNodeParent getParent() {
        return this.parent;
    }

    void setParent(SpanNodeParent parent) {
        this.parent = parent;
    }

    @Override
    public SpanTree getSpanTree() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getSpanTree();
    }

    private SpanTree getNonNullSpanTree() {
        SpanTree spanTree = this.getSpanTree();
        if (spanTree == null) {
            throw new NullPointerException(String.valueOf(this) + " is not attached to a SpanTree through its parent yet");
        }
        return spanTree;
    }

    public SpanNode annotate(Annotation annotation) {
        this.getNonNullSpanTree().annotate(this, annotation);
        return this;
    }

    public SpanNode annotate(AnnotationType type, FieldValue value) {
        this.getNonNullSpanTree().annotate(this, type, value);
        return this;
    }

    public SpanNode annotate(AnnotationType type, String value) {
        this.getNonNullSpanTree().annotate(this, type, new StringFieldValue(value));
        return this;
    }

    public SpanNode annotate(AnnotationType type, Integer value) {
        this.getNonNullSpanTree().annotate(this, type, new IntegerFieldValue(value));
        return this;
    }

    public SpanNode annotate(AnnotationType type) {
        this.getNonNullSpanTree().annotate(this, type);
        return this;
    }

    @Override
    public StringFieldValue getStringFieldValue() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getStringFieldValue();
    }

    public abstract boolean isLeafNode();

    public abstract ListIterator<SpanNode> childIterator();

    public abstract ListIterator<SpanNode> childIteratorRecursive();

    public abstract int getFrom();

    public abstract int getTo();

    public abstract int getLength();

    public abstract CharSequence getText(CharSequence var1);

    public boolean overlaps(SpanNode o) {
        int from = this.getFrom();
        int otherFrom = o.getFrom();
        int to = this.getTo();
        int otherTo = o.getTo();
        if (otherFrom >= from && otherFrom < to || from >= otherFrom && from < otherTo) {
            return true;
        }
        return otherTo > from && otherTo <= to || to > otherFrom && to <= otherTo;
    }

    public boolean contains(SpanNode o) {
        int from = this.getFrom();
        int otherFrom = o.getFrom();
        int to = this.getTo();
        int otherTo = o.getTo();
        return otherFrom >= from && otherTo <= to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanNode)) {
            return false;
        }
        SpanNode spanNode = (SpanNode)o;
        if (this.getFrom() != spanNode.getFrom()) {
            return false;
        }
        return this.getTo() == spanNode.getTo();
    }

    public int hashCode() {
        int result = this.getFrom();
        result = 31 * result + this.getTo();
        return result;
    }

    @Override
    public int compareTo(SpanNode o) {
        int otherTo;
        int otherFrom;
        int from = this.getFrom();
        if (from < (otherFrom = o.getFrom())) {
            return -1;
        }
        if (from > otherFrom) {
            return 1;
        }
        int to = this.getTo();
        if (to < (otherTo = o.getTo())) {
            return -1;
        }
        if (to > otherTo) {
            return 1;
        }
        return 0;
    }
}

