/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.FieldPath;
import com.yahoo.document.FieldPathEntry;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.CompositeFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public abstract class StructuredFieldValue
extends CompositeFieldValue {
    public static final int classId = StructuredFieldValue.registerClass((int)4128, StructuredFieldValue.class);

    protected StructuredFieldValue(StructuredDataType type) {
        super(type);
    }

    @Override
    public StructuredDataType getDataType() {
        return (StructuredDataType)super.getDataType();
    }

    public abstract Field getField(String var1);

    public abstract FieldValue getFieldValue(Field var1);

    public FieldValue getFieldValue(String fieldName) {
        Field field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        return this.getFieldValue(field);
    }

    public FieldValue setFieldValue(Field field, FieldValue value) {
        if (value == null) {
            return this.removeFieldValue(field);
        }
        DataType type = field.getDataType();
        if (!type.getValueClass().isAssignableFrom(value.getClass())) {
            FieldValue tmp = type.createFieldValue();
            tmp.assign(value);
            value = tmp;
        }
        FieldValue ret = this.getFieldValue(field);
        this.doSetFieldValue(field, value);
        return ret;
    }

    protected abstract void doSetFieldValue(Field var1, FieldValue var2);

    public FieldValue setFieldValue(String fieldName, FieldValue value) {
        Field field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        return this.setFieldValue(field, value);
    }

    public final FieldValue setFieldValue(Field field, String value) {
        return this.setFieldValue(field, (FieldValue)new StringFieldValue(value));
    }

    public final FieldValue setFieldValue(Field field, Double value) {
        return this.setFieldValue(field, (FieldValue)new DoubleFieldValue(value));
    }

    public final FieldValue setFieldValue(Field field, Integer value) {
        return this.setFieldValue(field, (FieldValue)new IntegerFieldValue(value));
    }

    public final FieldValue setFieldValue(Field field, Long value) {
        return this.setFieldValue(field, (FieldValue)new LongFieldValue(value));
    }

    public final FieldValue setFieldValue(Field field, Byte value) {
        return this.setFieldValue(field, (FieldValue)new ByteFieldValue(value));
    }

    public final FieldValue setFieldValue(String field, String value) {
        return this.setFieldValue(field, (FieldValue)new StringFieldValue(value));
    }

    public final FieldValue setFieldValue(String field, Double value) {
        return this.setFieldValue(field, (FieldValue)new DoubleFieldValue(value));
    }

    public final FieldValue setFieldValue(String field, Integer value) {
        return this.setFieldValue(field, (FieldValue)new IntegerFieldValue(value));
    }

    public final FieldValue setFieldValue(String field, Long value) {
        return this.setFieldValue(field, (FieldValue)new LongFieldValue(value));
    }

    public final FieldValue setFieldValue(String field, Byte value) {
        return this.setFieldValue(field, (FieldValue)new ByteFieldValue(value));
    }

    public final FieldValue setFieldValue(String field, Boolean value) {
        return this.setFieldValue(field, (FieldValue)new BoolFieldValue(value));
    }

    public abstract FieldValue removeFieldValue(Field var1);

    public FieldValue removeFieldValue(String fieldName) {
        Field field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        return this.removeFieldValue(field);
    }

    @Override
    public abstract void clear();

    public abstract int getFieldCount();

    public abstract Iterator<Map.Entry<Field, FieldValue>> iterator();

    @Override
    public FieldPathIteratorHandler.ModificationStatus iterateNested(FieldPath fieldPath, int pos, FieldPathIteratorHandler handler) {
        if (pos < fieldPath.size()) {
            if (fieldPath.get(pos).getType() == FieldPathEntry.Type.STRUCT_FIELD) {
                FieldValue newVal;
                FieldPathIteratorHandler.ModificationStatus status;
                FieldValue fieldVal = this.getFieldValue(fieldPath.get(pos).getFieldRef());
                if (fieldVal != null) {
                    FieldPathIteratorHandler.ModificationStatus status2 = fieldVal.iterateNested(fieldPath, pos + 1, handler);
                    if (status2 == FieldPathIteratorHandler.ModificationStatus.REMOVED) {
                        this.removeFieldValue(fieldPath.get(pos).getFieldRef());
                        return FieldPathIteratorHandler.ModificationStatus.MODIFIED;
                    }
                    if (this.isGenerated()) {
                        this.setFieldValue(fieldPath.get(pos).getFieldRef(), fieldVal);
                    }
                    return status2;
                }
                if (handler.createMissingPath() && (status = (newVal = fieldPath.get(pos).getFieldRef().getDataType().createFieldValue()).iterateNested(fieldPath, pos + 1, handler)) == FieldPathIteratorHandler.ModificationStatus.MODIFIED) {
                    this.setFieldValue(fieldPath.get(pos).getFieldRef(), newVal);
                    return status;
                }
                return FieldPathIteratorHandler.ModificationStatus.NOT_MODIFIED;
            }
            throw new IllegalArgumentException("Illegal field path " + String.valueOf(fieldPath.get(pos)) + " for struct value");
        }
        FieldPathIteratorHandler.ModificationStatus status = handler.modify(this);
        if (status == FieldPathIteratorHandler.ModificationStatus.REMOVED) {
            return status;
        }
        if (handler.onComplex(this)) {
            ArrayList<Field> fieldsToRemove = new ArrayList<Field>();
            Iterator<Map.Entry<Field, FieldValue>> iter = this.iterator();
            while (iter.hasNext()) {
                Map.Entry<Field, FieldValue> entry = iter.next();
                FieldPathIteratorHandler.ModificationStatus currStatus = entry.getValue().iterateNested(fieldPath, pos, handler);
                if (currStatus == FieldPathIteratorHandler.ModificationStatus.REMOVED) {
                    fieldsToRemove.add(entry.getKey());
                    status = FieldPathIteratorHandler.ModificationStatus.MODIFIED;
                    continue;
                }
                if (currStatus != FieldPathIteratorHandler.ModificationStatus.MODIFIED) continue;
                status = currStatus;
            }
            for (Field field : fieldsToRemove) {
                this.removeFieldValue(field);
            }
        }
        return status;
    }

    protected boolean isGenerated() {
        return false;
    }
}

