/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.objects.ObjectVisitor;
import java.util.Objects;

public class PrimitiveDataType
extends DataType {
    public static final int classId = PrimitiveDataType.registerClass((int)4147, PrimitiveDataType.class);
    private final Class<? extends FieldValue> valueClass;
    private final Factory factory;

    protected PrimitiveDataType(String name, int code, Class<? extends FieldValue> valueClass, Factory factory) {
        super(name, code);
        Objects.requireNonNull(valueClass, "valueClass");
        Objects.requireNonNull(factory, "factory");
        this.valueClass = valueClass;
        this.factory = factory;
    }

    @Override
    public PrimitiveDataType clone() {
        return (PrimitiveDataType)super.clone();
    }

    @Override
    public FieldValue createFieldValue() {
        return this.factory.create();
    }

    @Override
    public FieldValue createFieldValue(Object arg) {
        if (arg == null) {
            return this.factory.create();
        }
        if (arg instanceof String) {
            return this.factory.create((String)arg);
        }
        return super.createFieldValue(arg);
    }

    @Override
    public Class<? extends FieldValue> getValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean isValueCompatible(FieldValue value) {
        return value != null && this.valueClass.isAssignableFrom(value.getClass());
    }

    @Override
    public PrimitiveDataType getPrimitiveType() {
        return this;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("valueclass", (Object)this.valueClass.getName());
    }

    public static abstract class Factory {
        public abstract FieldValue create();

        public abstract FieldValue create(String var1);
    }
}

