/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.api.annotations.Beta;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentType;
import java.util.Objects;

public class DocumentPut
extends DocumentOperation {
    private final Document document;
    private boolean createIfNonExistent;

    public DocumentPut(Document document) {
        this.document = document;
    }

    public DocumentPut(DocumentType docType, DocumentId docId) {
        this.document = new Document(docType, docId);
    }

    public DocumentPut(DocumentType docType, String docId) {
        this.document = new Document(docType, docId);
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public DocumentId getId() {
        return this.document.getId();
    }

    public DocumentPut(DocumentPut other) {
        super(other);
        this.document = new Document(other.getDocument());
        this.createIfNonExistent = other.createIfNonExistent;
    }

    public DocumentPut(DocumentPut other, Document newDocument) {
        super(other);
        this.document = newDocument;
        this.createIfNonExistent = other.createIfNonExistent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentPut that = (DocumentPut)o;
        return this.document.equals(that.document) && this.createIfNonExistent == that.createIfNonExistent && Objects.equals(this.getCondition(), that.getCondition());
    }

    public int hashCode() {
        return Objects.hash(this.document, this.getCondition());
    }

    public String toString() {
        return "put of document " + this.getId();
    }

    @Beta
    public void setCreateIfNonExistent(boolean value) {
        this.createIfNonExistent = value;
    }

    @Beta
    public boolean getCreateIfNonExistent() {
        return this.createIfNonExistent;
    }
}

