/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.ReferenceFieldValue;

public class ReferenceDataType
extends DataType {
    public static final int classId = ReferenceDataType.registerClass((int)4164, ReferenceDataType.class);
    private final StructuredDataType targetType;

    public ReferenceDataType(DocumentType targetType, int id) {
        this((StructuredDataType)targetType, id);
    }

    private ReferenceDataType(StructuredDataType targetType, int id) {
        super(ReferenceDataType.buildTypeName(targetType), id);
        this.targetType = targetType;
    }

    private ReferenceDataType(StructuredDataType targetType) {
        this(targetType, ReferenceDataType.buildTypeName(targetType).hashCode());
    }

    private static String buildTypeName(StructuredDataType targetType) {
        return "Reference<" + targetType.getName() + ">";
    }

    public static ReferenceDataType createWithInferredId(DocumentType targetType) {
        return new ReferenceDataType(targetType);
    }

    public StructuredDataType getTargetType() {
        return this.targetType;
    }

    @Override
    public ReferenceFieldValue createFieldValue() {
        return new ReferenceFieldValue(this);
    }

    @Override
    public Class<? extends ReferenceFieldValue> getValueClass() {
        return ReferenceFieldValue.class;
    }

    @Override
    public boolean isValueCompatible(FieldValue value) {
        if (value == null) {
            return false;
        }
        if (!ReferenceFieldValue.class.isAssignableFrom(value.getClass())) {
            return false;
        }
        ReferenceFieldValue rhs = (ReferenceFieldValue)value;
        return rhs.getDataType().equals(this);
    }

    private int compareTargetType(DataType rhs) {
        return rhs instanceof ReferenceDataType ? this.targetType.compareTo(((ReferenceDataType)rhs).targetType) : 0;
    }

    @Override
    public int compareTo(DataType rhs) {
        int cmp = super.compareTo(rhs);
        return cmp != 0 ? cmp : this.compareTargetType(rhs);
    }

    @Override
    public boolean equals(Object rhs) {
        return super.equals(rhs) && rhs instanceof ReferenceDataType && this.targetType.equals(((ReferenceDataType)rhs).targetType);
    }
}

