/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.jdisc.observability;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.handler.observability.ApplicationStatusHandler;
import com.yahoo.docproc.Call;
import com.yahoo.docproc.impl.DocprocService;
import com.yahoo.docproc.jdisc.DocumentProcessingHandler;
import com.yahoo.jdisc.handler.RequestHandler;
import java.util.Iterator;
import java.util.Map;

public class DocprocsStatusExtension
implements ApplicationStatusHandler.Extension {
    public Map<String, ? extends JsonNode> produceExtraFields(ApplicationStatusHandler statusHandler) {
        return Map.of("docprocChains", DocprocsStatusExtension.renderDocprocChains(statusHandler));
    }

    private static JsonNode renderDocprocChains(ApplicationStatusHandler statusHandler) {
        ObjectNode ret = statusHandler.jsonMapper().createObjectNode();
        for (RequestHandler h : statusHandler.requestHandlers()) {
            if (!(h instanceof DocumentProcessingHandler)) continue;
            ComponentRegistry<DocprocService> registry = ((DocumentProcessingHandler)h).getDocprocServiceRegistry();
            for (DocprocService service : registry.allComponents()) {
                ret.set(service.getId().stringValue(), DocprocsStatusExtension.renderCalls(statusHandler, service.getCallStack().iterator()));
            }
        }
        return ret;
    }

    private static JsonNode renderCalls(ApplicationStatusHandler statusHandler, Iterator<Call> components) {
        ArrayNode ret = statusHandler.jsonMapper().createArrayNode();
        while (components.hasNext()) {
            Call c = components.next();
            ObjectNode jc = ApplicationStatusHandler.renderComponent((Object)((Object)c.getDocumentProcessor()), (ComponentId)c.getDocumentProcessor().getId());
            ret.add((JsonNode)jc);
        }
        return ret;
    }
}

