// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.config.docproc;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of splitter-joiner-document-processor
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class SplitterJoinerDocumentProcessorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "bf3a98371fd4e0763f3752a1a6b72ee4";
  public final static String CONFIG_DEF_NAME = "splitter-joiner-document-processor";
  public final static String CONFIG_DEF_NAMESPACE = "config.docproc";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=config.docproc",
    "documentTypeName string",
    "arrayFieldName string",
    "contextFieldName string default=\"docproc@splitter@joiner@outer@document\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "documentTypeName",
      "arrayFieldName"
      ));

    private String documentTypeName = null;
    private String arrayFieldName = null;
    private String contextFieldName = null;

    public Builder() { }

    public Builder(SplitterJoinerDocumentProcessorConfig config) {
      documentTypeName(config.documentTypeName());
      arrayFieldName(config.arrayFieldName());
      contextFieldName(config.contextFieldName());
    }

    private Builder override(Builder __superior) {
      if (__superior.documentTypeName != null)
        documentTypeName(__superior.documentTypeName);
      if (__superior.arrayFieldName != null)
        arrayFieldName(__superior.arrayFieldName);
      if (__superior.contextFieldName != null)
        contextFieldName(__superior.contextFieldName);
      return this;
    }

    public Builder documentTypeName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      documentTypeName = __value;
      __uninitialized.remove("documentTypeName");
      return this;
    }


    public Builder arrayFieldName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      arrayFieldName = __value;
      __uninitialized.remove("arrayFieldName");
      return this;
    }


    public Builder contextFieldName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      contextFieldName = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SplitterJoinerDocumentProcessorConfig build() {
      return new SplitterJoinerDocumentProcessorConfig(this);
    }

  }

  // The name of the enclosing (outer) document type
  private final StringNode documentTypeName;
  // The name of the field of type array of document
  private final StringNode arrayFieldName;
  // The name of the context variable used by Processing.getVariable()
  private final StringNode contextFieldName;

  public SplitterJoinerDocumentProcessorConfig(Builder builder) {
    this(builder, true);
  }

  private SplitterJoinerDocumentProcessorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "splitter-joiner-document-processor must be initialized: " + builder.__uninitialized);

    documentTypeName = (builder.documentTypeName == null) ?
        new StringNode() : new StringNode(builder.documentTypeName);
    arrayFieldName = (builder.arrayFieldName == null) ?
        new StringNode() : new StringNode(builder.arrayFieldName);
    contextFieldName = (builder.contextFieldName == null) ?
        new StringNode("docproc@splitter@joiner@outer@document") : new StringNode(builder.contextFieldName);
  }

  /**
   * @return splitter-joiner-document-processor.documentTypeName
   */
  public String documentTypeName() {
    return documentTypeName.value();
  }

  /**
   * @return splitter-joiner-document-processor.arrayFieldName
   */
  public String arrayFieldName() {
    return arrayFieldName.value();
  }

  /**
   * @return splitter-joiner-document-processor.contextFieldName
   */
  public String contextFieldName() {
    return contextFieldName.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SplitterJoinerDocumentProcessorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("splitter-joiner-document-processor");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
