// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.config.docproc;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of schemamapping
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Use when a docproc works on a generic set of field names and the actual names
 * in input doc may be different
 */
public final class SchemamappingConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "491e210444b13916af64bdb2435f2e3b";
  public final static String CONFIG_DEF_NAME = "schemamapping";
  public final static String CONFIG_DEF_NAMESPACE = "config.docproc";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=config.docproc",
    "fieldmapping[].chain string",
    "fieldmapping[].docproc string",
    "fieldmapping[].doctype string default=\"\"",
    "fieldmapping[].indocument string",
    "fieldmapping[].inprocessor string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Fieldmapping.Builder> fieldmapping = new ArrayList<>();

    public Builder() { }

    public Builder(SchemamappingConfig config) {
      for (Fieldmapping f : config.fieldmapping()) {
        fieldmapping(new Fieldmapping.Builder(f));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.fieldmapping.isEmpty())
        fieldmapping.addAll(__superior.fieldmapping);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Fieldmapping builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder fieldmapping(Fieldmapping.Builder __builder) {
      fieldmapping.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder fieldmapping(java.util.function.Consumer<Fieldmapping.Builder> __func) {
      Fieldmapping.Builder __inner = new Fieldmapping.Builder();
      __func.accept(__inner);
      fieldmapping.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Fieldmapping builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder fieldmapping(List<Fieldmapping.Builder> __builders) {
      fieldmapping = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public SchemamappingConfig build() {
      return new SchemamappingConfig(this);
    }

  }

  private final InnerNodeVector<Fieldmapping> fieldmapping;

  public SchemamappingConfig(Builder builder) {
    this(builder, true);
  }

  private SchemamappingConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "schemamapping must be initialized: " + builder.__uninitialized);

    fieldmapping = Fieldmapping.createVector(builder.fieldmapping);
  }

  /**
   * @return schemamapping.fieldmapping[]
   */
  public List<Fieldmapping> fieldmapping() {
    return fieldmapping;
  }

  /**
   * @param i the index of the value to return
   * @return schemamapping.fieldmapping[]
   */
  public Fieldmapping fieldmapping(int i) {
    return fieldmapping.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(SchemamappingConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("schemamapping");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents schemamapping.fieldmapping[]
   */
  public final static class Fieldmapping extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "chain",
        "docproc",
        "indocument",
        "inprocessor"
        ));

      private String chain = null;
      private String docproc = null;
      private String doctype = null;
      private String indocument = null;
      private String inprocessor = null;

      public Builder() { }

      public Builder(Fieldmapping config) {
        chain(config.chain());
        docproc(config.docproc());
        doctype(config.doctype());
        indocument(config.indocument());
        inprocessor(config.inprocessor());
      }

      private Builder override(Builder __superior) {
        if (__superior.chain != null)
          chain(__superior.chain);
        if (__superior.docproc != null)
          docproc(__superior.docproc);
        if (__superior.doctype != null)
          doctype(__superior.doctype);
        if (__superior.indocument != null)
          indocument(__superior.indocument);
        if (__superior.inprocessor != null)
          inprocessor(__superior.inprocessor);
        return this;
      }

      public Builder chain(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        chain = __value;
        __uninitialized.remove("chain");
        return this;
      }


      public Builder docproc(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        docproc = __value;
        __uninitialized.remove("docproc");
        return this;
      }


      public Builder doctype(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        doctype = __value;
        return this;
      }


      public Builder indocument(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        indocument = __value;
        __uninitialized.remove("indocument");
        return this;
      }


      public Builder inprocessor(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        inprocessor = __value;
        __uninitialized.remove("inprocessor");
        return this;
      }


      public Fieldmapping build() {
        return new Fieldmapping(this);
      }

    }

    // The chain this mapping applies to
    private final StringNode chain;
    // The class name of the docproc this mapping applies to
    private final StringNode docproc;
    // The doc type name this mapping applies to
    private final StringNode doctype;
    // Field name in input doc
    private final StringNode indocument;
    // Field name a docproc uses
    private final StringNode inprocessor;

    public Fieldmapping(Builder builder) {
      this(builder, true);
    }

    private Fieldmapping(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "schemamapping.fieldmapping[] must be initialized: " + builder.__uninitialized);

      chain = (builder.chain == null) ?
          new StringNode() : new StringNode(builder.chain);
      docproc = (builder.docproc == null) ?
          new StringNode() : new StringNode(builder.docproc);
      doctype = (builder.doctype == null) ?
          new StringNode("") : new StringNode(builder.doctype);
      indocument = (builder.indocument == null) ?
          new StringNode() : new StringNode(builder.indocument);
      inprocessor = (builder.inprocessor == null) ?
          new StringNode() : new StringNode(builder.inprocessor);
    }

    /**
     * @return schemamapping.fieldmapping[].chain
     */
    public String chain() {
      return chain.value();
    }

    /**
     * @return schemamapping.fieldmapping[].docproc
     */
    public String docproc() {
      return docproc.value();
    }

    /**
     * @return schemamapping.fieldmapping[].doctype
     */
    public String doctype() {
      return doctype.value();
    }

    /**
     * @return schemamapping.fieldmapping[].indocument
     */
    public String indocument() {
      return indocument.value();
    }

    /**
     * @return schemamapping.fieldmapping[].inprocessor
     */
    public String inprocessor() {
      return inprocessor.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Fieldmapping newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldmapping");
      return changes;
    }

    private static InnerNodeVector<Fieldmapping> createVector(List<Builder> builders) {
        List<Fieldmapping> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Fieldmapping(b));
        }
        return new InnerNodeVector<Fieldmapping>(elems);
    }
  }

}
