// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.config.docproc;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of docproc
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class DocprocConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "c75b541ab1af87ad5d99d2bc0412f7bd";
  public final static String CONFIG_DEF_NAME = "docproc";
  public final static String CONFIG_DEF_NAMESPACE = "config.docproc";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=config.docproc",
    "maxqueuetimems int default=-1",
    "numthreads int default=-1"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer maxqueuetimems = null;
    private Integer numthreads = null;

    public Builder() { }

    public Builder(DocprocConfig config) {
      maxqueuetimems(config.maxqueuetimems());
      numthreads(config.numthreads());
    }

    private Builder override(Builder __superior) {
      if (__superior.maxqueuetimems != null)
        maxqueuetimems(__superior.maxqueuetimems);
      if (__superior.numthreads != null)
        numthreads(__superior.numthreads);
      return this;
    }

    public Builder maxqueuetimems(int __value) {
      maxqueuetimems = __value;
      return this;
    }

    private Builder maxqueuetimems(String __value) {
      return maxqueuetimems(Integer.valueOf(__value));
    }

    public Builder numthreads(int __value) {
      numthreads = __value;
      return this;
    }

    private Builder numthreads(String __value) {
      return numthreads(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DocprocConfig build() {
      return new DocprocConfig(this);
    }

  }

  // Depreacated and a noop
  private final IntegerNode maxqueuetimems;
  // The number of threads in the DocprocHandler worker thread pool
  // Default is number of cpu's, but any positive number larger than 0 will be used explicit.
  private final IntegerNode numthreads;

  public DocprocConfig(Builder builder) {
    this(builder, true);
  }

  private DocprocConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "docproc must be initialized: " + builder.__uninitialized);

    maxqueuetimems = (builder.maxqueuetimems == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.maxqueuetimems);
    numthreads = (builder.numthreads == null) ?
        new IntegerNode(-1) : new IntegerNode(builder.numthreads);
  }

  /**
   * @return docproc.maxqueuetimems
   */
  public int maxqueuetimems() {
    return maxqueuetimems.value();
  }

  /**
   * @return docproc.numthreads
   */
  public int numthreads() {
    return numthreads.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DocprocConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("docproc");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
