/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates;

import com.yahoo.search.pagetemplates.model.MapChoice;
import com.yahoo.search.pagetemplates.model.PageTemplateVisitor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class PlaceholderMappingVisitor
extends PageTemplateVisitor {
    private final Map<String, MapChoice> placeholderIdToChoice = new LinkedHashMap<String, MapChoice>();

    PlaceholderMappingVisitor() {
    }

    @Override
    public void visit(MapChoice mapChoice) {
        List<String> placeholderIds = mapChoice.placeholderIds();
        for (String placeholderId : placeholderIds) {
            MapChoice existingChoice = this.placeholderIdToChoice.put(placeholderId, mapChoice);
            if (existingChoice == null) continue;
            throw new IllegalArgumentException("placeholder id '" + placeholderId + "' is referenced by both " + String.valueOf(mapChoice) + " and " + String.valueOf(existingChoice) + ": Only one reference is allowed");
        }
    }

    public Map<String, MapChoice> getMap() {
        return this.placeholderIdToChoice;
    }
}

